/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.results;

import com.powsybl.commons.extensions.AbstractExtendable;
import java.util.Objects;

public class BusResult
extends AbstractExtendable<BusResult> {
    private final String voltageLevelId;
    private final String busId;
    private final double v;
    private final double angle;

    public BusResult(String voltageLevelId, String busId, double v, double angle) {
        this.voltageLevelId = Objects.requireNonNull(voltageLevelId);
        this.busId = Objects.requireNonNull(busId);
        this.v = v;
        this.angle = angle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BusResult that = (BusResult)((Object)o);
        return Double.compare(that.v, this.v) == 0 && Double.compare(that.angle, this.angle) == 0 && Objects.equals(this.voltageLevelId, that.voltageLevelId) && Objects.equals(this.busId, that.busId);
    }

    public int hashCode() {
        return Objects.hash(this.voltageLevelId, this.busId, this.v, this.angle);
    }

    public String getBusId() {
        return this.busId;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getV() {
        return this.v;
    }

    public String getVoltageLevelId() {
        return this.voltageLevelId;
    }

    public String toString() {
        return "BusResults{voltageLevelId='" + this.voltageLevelId + "', busId='" + this.busId + "', v=" + this.v + ", angle=" + this.angle + "}";
    }
}

