/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.results;

import com.powsybl.commons.PowsyblException;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OperatorStrategyResult {
    private final OperatorStrategy operatorStrategy;
    private List<ConditionalActionsResult> conditionalActionsResults = new ArrayList<ConditionalActionsResult>();

    public OperatorStrategyResult(OperatorStrategy operatorStrategy, PostContingencyComputationStatus status, LimitViolationsResult limitViolationsResult, NetworkResult networkResult) {
        this.operatorStrategy = Objects.requireNonNull(operatorStrategy);
        this.conditionalActionsResults.add(new ConditionalActionsResult(operatorStrategy.getId(), status, limitViolationsResult, networkResult));
    }

    public OperatorStrategyResult(OperatorStrategy operatorStrategy, List<ConditionalActionsResult> conditionalActionsResults) {
        this.operatorStrategy = Objects.requireNonNull(operatorStrategy);
        this.conditionalActionsResults = conditionalActionsResults;
    }

    public PostContingencyComputationStatus getStatus() {
        return this.getFinalOperatorStrategyResult().getStatus();
    }

    public LimitViolationsResult getLimitViolationsResult() {
        return this.getFinalOperatorStrategyResult().getLimitViolationsResult();
    }

    public NetworkResult getNetworkResult() {
        return this.getFinalOperatorStrategyResult().getNetworkResult();
    }

    public OperatorStrategy getOperatorStrategy() {
        return this.operatorStrategy;
    }

    public List<ConditionalActionsResult> getConditionalActionsResults() {
        return this.conditionalActionsResults;
    }

    public ConditionalActionsResult getFinalOperatorStrategyResult() {
        if (!this.conditionalActionsResults.isEmpty()) {
            return this.conditionalActionsResults.get(this.conditionalActionsResults.size() - 1);
        }
        throw new PowsyblException("No conditional action results available.");
    }

    public static class ConditionalActionsResult {
        private final String conditionalActionsId;
        private final PostContingencyComputationStatus status;
        private final LimitViolationsResult limitViolationsResult;
        private final NetworkResult networkResult;

        public ConditionalActionsResult(String conditionalActionsId, PostContingencyComputationStatus status, LimitViolationsResult limitViolationsResult, NetworkResult networkResult) {
            this.conditionalActionsId = conditionalActionsId;
            this.status = Objects.requireNonNull(status);
            this.limitViolationsResult = Objects.requireNonNull(limitViolationsResult);
            this.networkResult = Objects.requireNonNull(networkResult);
        }

        public String getConditionalActionsId() {
            return this.conditionalActionsId;
        }

        public PostContingencyComputationStatus getStatus() {
            return this.status;
        }

        public LimitViolationsResult getLimitViolationsResult() {
            return this.limitViolationsResult;
        }

        public NetworkResult getNetworkResult() {
            return this.networkResult;
        }
    }
}

