/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.tools;

import com.powsybl.action.ActionList;
import com.powsybl.commons.io.FileUtil;
import com.powsybl.commons.io.table.AsciiTableFormatterFactory;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.computation.ComputationException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.Partition;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.Security;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.converter.SecurityAnalysisResultExporters;
import com.powsybl.security.execution.AbstractSecurityAnalysisExecutionBuilder;
import com.powsybl.security.execution.AbstractSecurityAnalysisExecutionInput;
import com.powsybl.security.json.limitreduction.LimitReductionListSerDeUtil;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategyList;
import com.powsybl.tools.ToolOptions;
import com.powsybl.tools.ToolRunningContext;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public abstract class AbstractSecurityAnalysisTool<T extends AbstractSecurityAnalysisExecutionInput<T>, R extends AbstractSecurityAnalysisExecutionBuilder<R>> {
    public static Network readNetwork(CommandLine line, ToolRunningContext context, ImportersLoader importersLoader) throws IOException {
        ToolOptions options = new ToolOptions(line, context);
        Path caseFile = (Path)options.getPath("case-file").orElseThrow(IllegalStateException::new);
        Properties inputParams = ConversionToolUtils.readProperties((CommandLine)line, (ConversionToolUtils.OptionType)ConversionToolUtils.OptionType.IMPORT, (ToolRunningContext)context);
        context.getOutputStream().println("Loading network '" + caseFile + "'");
        Network network = Network.read((Path)caseFile, (ComputationManager)context.getShortTimeExecutionComputationManager(), (ImportConfig)ImportConfig.load(), (Properties)inputParams, (ImportersLoader)importersLoader);
        network.getVariantManager().allowVariantMultiThreadAccess(true);
        return network;
    }

    protected static void uncheckedWriteBytes(byte[] bytes, Path path) {
        try {
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void run(CommandLine line, ToolRunningContext context, R executionBuilder, ImportersLoader importersLoader, Supplier<TableFormatterConfig> tableFormatterConfigLoader) throws ParseException, IOException {
        ToolOptions options = new ToolOptions(line, context);
        Path outputFile = options.getPath("output-file").orElse(null);
        String format = this.getFormat(options, outputFile);
        Network network = AbstractSecurityAnalysisTool.readNetwork(line, context, importersLoader);
        T executionInput = this.getExecutionInput(network);
        this.updateInput(options, executionInput);
        Supplier<SecurityAnalysisReport> supplier = this.getReportSupplier(context, options, executionBuilder, executionInput);
        SecurityAnalysisResult result = options.getPath("log-file").map(logPath -> this.runSecurityAnalysisWithLog(supplier, (Path)logPath)).orElseGet(supplier).getResult();
        if (result.getPreContingencyResult().getStatus() != LoadFlowResult.ComponentResult.Status.CONVERGED) {
            context.getErrorStream().println("Pre-contingency state divergence");
        }
        if (outputFile != null) {
            context.getOutputStream().println("Writing results to '" + outputFile + "'");
            SecurityAnalysisResultExporters.export(result, outputFile, format);
        } else {
            OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
            Security.print(result, network, (Writer)writer, (TableFormatterFactory)new AsciiTableFormatterFactory(), tableFormatterConfigLoader.get());
        }
    }

    protected String getFormat(ToolOptions options, Path outputFile) throws ParseException {
        return outputFile != null ? (String)options.getValue("output-format").orElseThrow(() -> new ParseException("Missing required option: output-format")) : null;
    }

    protected abstract T getExecutionInput(Network var1);

    public void updateInput(ToolOptions options, T inputs) {
        options.getPath("contingencies-file").map(x$0 -> FileUtil.asByteSource((Path)x$0, (OpenOption[])new OpenOption[0])).ifPresent(arg_0 -> inputs.setContingenciesSource(arg_0));
        options.getValues("limit-types").map(types -> types.stream().map(LimitViolationType::valueOf).collect(Collectors.toList())).ifPresent(arg_0 -> inputs.addViolationTypes(arg_0));
        options.getValues("with-extensions").ifPresent(arg_0 -> inputs.addResultExtensions(arg_0));
        options.getValues("log-file").ifPresent(f -> inputs.setWithLogs(true));
        options.getPath("monitoring-file").ifPresent(monitorFilePath -> inputs.setMonitors(StateMonitor.read(monitorFilePath)));
        options.getPath("strategies-file").ifPresent(operatorStrategyFilePath -> inputs.setOperatorStrategies(OperatorStrategyList.read(operatorStrategyFilePath).getOperatorStrategies()));
        options.getPath("actions-file").ifPresent(actionFilePath -> inputs.setActions(ActionList.readJsonFile((Path)actionFilePath).getActions()));
        options.getPath("limit-reductions-file").ifPresent(limitReductionsFilePath -> inputs.setLimitReductions(LimitReductionListSerDeUtil.read(limitReductionsFilePath).getLimitReductions()));
    }

    protected SecurityAnalysisReport runSecurityAnalysisWithLog(Supplier<SecurityAnalysisReport> supplier, Path logPath) {
        try {
            SecurityAnalysisReport report = supplier.get();
            report.getLogBytes().ifPresent(logBytes -> AbstractSecurityAnalysisTool.uncheckedWriteBytes(logBytes, logPath));
            return report;
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ComputationException) {
                ComputationException computationException = (ComputationException)throwable;
                byte[] bytes = computationException.toZipBytes();
                AbstractSecurityAnalysisTool.uncheckedWriteBytes(bytes, logPath);
            }
            throw e;
        }
    }

    protected void setupExecutionBuilder(ToolOptions options, R builder) {
        ((AbstractSecurityAnalysisExecutionBuilder)builder).forward(options.hasOption("external"));
        options.getInt("task-count").ifPresent(arg_0 -> builder.distributed(arg_0));
        options.getValue("task", Partition::parse).ifPresent(arg_0 -> builder.subTask(arg_0));
    }

    protected abstract Supplier<SecurityAnalysisReport> getReportSupplier(ToolRunningContext var1, ToolOptions var2, R var3, T var4);
}

