/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.tools;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.computation.ComputationManager;
import com.powsybl.contingency.ContingenciesProviders;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.ImportersServiceLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.SecurityAnalysisInput;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import com.powsybl.security.execution.SecurityAnalysisExecutionBuilder;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import com.powsybl.security.execution.SecurityAnalysisInputBuildStrategy;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptors;
import com.powsybl.security.preprocessor.SecurityAnalysisPreprocessorFactory;
import com.powsybl.security.preprocessor.SecurityAnalysisPreprocessors;
import com.powsybl.security.tools.AbstractSecurityAnalysisTool;
import com.powsybl.security.tools.SecurityAnalysisCommand;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolOptions;
import com.powsybl.tools.ToolRunningContext;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;

@AutoService(value={Tool.class})
public class SecurityAnalysisTool
extends AbstractSecurityAnalysisTool<SecurityAnalysisExecutionInput, SecurityAnalysisExecutionBuilder>
implements Tool {
    public Command getCommand() {
        return new SecurityAnalysisCommand();
    }

    private static SecurityAnalysisInputBuildStrategy configBasedInputBuildStrategy(PlatformConfig config) {
        return SecurityAnalysisTool.preprocessedInputBuildStrategy(() -> LimitViolationFilter.load(config), SecurityAnalysisPreprocessors.configuredFactory(config).orElseGet(() -> SecurityAnalysisPreprocessors.wrap(ContingenciesProviders.newDefaultFactory((PlatformConfig)config))));
    }

    private static SecurityAnalysisInputBuildStrategy preprocessedInputBuildStrategy(Supplier<LimitViolationFilter> filterInitializer, SecurityAnalysisPreprocessorFactory preprocessorFactory) {
        return executionInput -> SecurityAnalysisTool.buildPreprocessedInput(executionInput, filterInitializer, preprocessorFactory);
    }

    static SecurityAnalysisInput buildPreprocessedInput(SecurityAnalysisExecutionInput executionInput, Supplier<LimitViolationFilter> filterInitializer, SecurityAnalysisPreprocessorFactory preprocessorFactory) {
        SecurityAnalysisInput input = (SecurityAnalysisInput)new SecurityAnalysisInput(executionInput.getNetworkVariant()).setParameters(executionInput.getParameters()).setFilter(filterInitializer.get());
        executionInput.getResultExtensions().stream().map(SecurityAnalysisInterceptors::createInterceptor).forEach(input::addInterceptor);
        if (!executionInput.getViolationTypes().isEmpty()) {
            input.getFilter().setViolationTypes((Set<LimitViolationType>)ImmutableSet.copyOf(executionInput.getViolationTypes()));
        }
        executionInput.getContingenciesSource().map(preprocessorFactory::newPreprocessor).ifPresent(p -> p.preprocess(input));
        return input;
    }

    private static SecurityAnalysisExecutionBuilder createBuilder(PlatformConfig platformConfig) {
        String providerName = platformConfig.getOptionalModuleConfig("security-analysis").flatMap(c -> c.getOptionalStringProperty("default-impl-name")).orElse(null);
        return new SecurityAnalysisExecutionBuilder(() -> ExternalSecurityAnalysisConfig.load(platformConfig), providerName, SecurityAnalysisTool.configBasedInputBuildStrategy(platformConfig));
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        this.run(line, context, SecurityAnalysisTool.createBuilder(PlatformConfig.defaultConfig()), (ImportersLoader)new ImportersServiceLoader(), TableFormatterConfig::load);
    }

    @Override
    protected SecurityAnalysisExecutionInput getExecutionInput(Network network) {
        return ((SecurityAnalysisExecutionInput)new SecurityAnalysisExecutionInput().setNetworkVariant(network, "InitialState")).setParameters(SecurityAnalysisParameters.load());
    }

    @Override
    protected Supplier<SecurityAnalysisReport> getReportSupplier(ToolRunningContext context, ToolOptions options, SecurityAnalysisExecutionBuilder executionBuilder, SecurityAnalysisExecutionInput executionInput) {
        ComputationManager computationManager = options.hasOption("task") ? context.getShortTimeExecutionComputationManager() : context.getLongTimeExecutionComputationManager();
        this.setupExecutionBuilder(options, executionBuilder);
        return () -> executionBuilder.build().execute(computationManager, executionInput).join();
    }
}

