/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.security.ViolationLocation;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NodeBreakerViolationLocation
implements ViolationLocation {
    private final String voltageLevelId;
    private final List<Integer> nodes;

    public NodeBreakerViolationLocation(String voltageLevelId, List<Integer> nodes) {
        this.voltageLevelId = Objects.requireNonNull(voltageLevelId, "voltageLevelId should not be null");
        this.nodes = Objects.requireNonNull(nodes, "nodes should not be null");
    }

    public String getVoltageLevelId() {
        return this.voltageLevelId;
    }

    public List<Integer> getNodes() {
        return this.nodes;
    }

    @Override
    public ViolationLocation.BusView getBusView(Network network) {
        return () -> {
            VoltageLevel vl = network.getVoltageLevel(this.voltageLevelId);
            VoltageLevel.BusView busView = vl.getBusView();
            return Networks.getNodesByBus((VoltageLevel)vl).entrySet().stream().filter(e -> this.nodes.stream().anyMatch(i -> ((Set)e.getValue()).contains(i))).map(e -> busView.getBus((String)e.getKey())).distinct();
        };
    }

    @Override
    public ViolationLocation.BusView getBusBreakerView(Network network) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ViolationLocation.Type getType() {
        return ViolationLocation.Type.NODE_BREAKER;
    }

    public String toString() {
        return "NodeBreakerVoltageLocation{voltageLevelId='" + this.voltageLevelId + "', nodes=" + this.nodes + "}";
    }
}

