/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.strategy.OperatorStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class OperatorStrategyResultDeserializer
extends StdDeserializer<OperatorStrategyResult> {
    private static final String CONTEXT_NAME = "OperatorStrategyResult";

    public OperatorStrategyResultDeserializer() {
        super(OperatorStrategyResult.class);
    }

    public OperatorStrategyResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        OperatorStrategy operatorStrategy = null;
        LimitViolationsResult limitViolationsResult = null;
        NetworkResult networkResult = null;
        PostContingencyComputationStatus status = null;
        List conditionalActionsResultList = null;
        String version = JsonUtil.getSourceVersion((DatabindContext)deserializationContext, (String)"sourceVersionAttribute");
        if (version == null) {
            version = "1.7";
        }
        block14: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "operatorStrategy": {
                    parser.nextToken();
                    operatorStrategy = (OperatorStrategy)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, OperatorStrategy.class));
                    continue block14;
                }
                case "limitViolationsResult": {
                    parser.nextToken();
                    limitViolationsResult = (LimitViolationsResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolationsResult.class);
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: limitViolationsResult", (String)version, (String)"1.5");
                    continue block14;
                }
                case "networkResult": {
                    parser.nextToken();
                    networkResult = (NetworkResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, NetworkResult.class);
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: networkResult", (String)version, (String)"1.5");
                    continue block14;
                }
                case "status": {
                    parser.nextToken();
                    status = (PostContingencyComputationStatus)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, PostContingencyComputationStatus.class));
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: contingencyStatus", (String)version, (String)"1.3");
                    JsonUtil.assertLessThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: contingencyStatus", (String)version, (String)"1.6");
                    continue block14;
                }
                case "conditionalActionsResults": {
                    parser.nextToken();
                    conditionalActionsResultList = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, OperatorStrategyResult.ConditionalActionsResult.class);
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: conditionalActionsResults", (String)version, (String)"1.6");
                    continue block14;
                }
            }
            throw new JsonMappingException((Closeable)parser, "Unexpected field: " + parser.currentName());
        }
        if (version.compareTo("1.3") < 0) {
            Objects.requireNonNull(limitViolationsResult);
            return new OperatorStrategyResult(operatorStrategy, limitViolationsResult.isComputationOk() ? PostContingencyComputationStatus.CONVERGED : PostContingencyComputationStatus.FAILED, limitViolationsResult, networkResult);
        }
        if (version.compareTo("1.6") < 0) {
            return new OperatorStrategyResult(operatorStrategy, status, limitViolationsResult, networkResult);
        }
        return new OperatorStrategyResult(operatorStrategy, conditionalActionsResultList);
    }
}

