/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.BusBreakerViolationLocation;
import com.powsybl.security.NodeBreakerViolationLocation;
import com.powsybl.security.ViolationLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ViolationLocationDeserializer
extends StdDeserializer<ViolationLocation> {
    private static final String BUS_IDS = "busIds";
    private static final String VOLTAGE_LEVEL_ID = "voltageLevelId";
    private static final String NODES = "nodes";

    public ViolationLocationDeserializer() {
        super(ViolationLocation.class);
    }

    public ViolationLocation deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String voltageLevelId = null;
        List<String> busIds = new ArrayList<String>();
        List<Integer> nodes = new ArrayList<Integer>();
        ViolationLocation.Type type = null;
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "type": {
                    parser.nextToken();
                    type = (ViolationLocation.Type)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ViolationLocation.Type.class));
                    continue block12;
                }
                case "busIds": {
                    parser.nextToken();
                    busIds = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, String.class);
                    continue block12;
                }
                case "voltageLevelId": {
                    voltageLevelId = parser.nextTextValue();
                    continue block12;
                }
                case "nodes": {
                    parser.nextToken();
                    nodes = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, Integer.class);
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        if (type == ViolationLocation.Type.NODE_BREAKER) {
            return new NodeBreakerViolationLocation(voltageLevelId, nodes);
        }
        if (type == ViolationLocation.Type.BUS_BREAKER) {
            return new BusBreakerViolationLocation(busIds);
        }
        throw new IllegalStateException("type should be among [NODE_BREAKER, BUS_BREAKER].");
    }
}

