/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.BusBreakerViolationLocation;
import com.powsybl.security.NodeBreakerViolationLocation;
import com.powsybl.security.ViolationLocation;
import java.io.IOException;

public class ViolationLocationSerializer
extends StdSerializer<ViolationLocation> {
    public ViolationLocationSerializer() {
        super(ViolationLocation.class);
    }

    public void serialize(ViolationLocation violationLocation, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        JsonUtil.writeOptionalEnumField((JsonGenerator)jsonGenerator, (String)"type", (Enum)violationLocation.getType());
        if (ViolationLocation.Type.NODE_BREAKER == violationLocation.getType()) {
            NodeBreakerViolationLocation location = (NodeBreakerViolationLocation)violationLocation;
            jsonGenerator.writeStringField("voltageLevelId", location.getVoltageLevelId());
            serializerProvider.defaultSerializeField("nodes", location.getNodes(), jsonGenerator);
        } else {
            BusBreakerViolationLocation location = (BusBreakerViolationLocation)violationLocation;
            serializerProvider.defaultSerializeField("busIds", location.getBusIds(), jsonGenerator);
        }
        jsonGenerator.writeEndObject();
    }
}

