/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.limitreduction;

import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.iidm.criteria.NetworkElementCriterion;
import com.powsybl.iidm.criteria.NetworkElementVisitor;
import com.powsybl.iidm.criteria.duration.AbstractTemporaryDurationCriterion;
import com.powsybl.iidm.criteria.duration.LimitDurationCriterion;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.limitmodification.AbstractLimitsComputerWithCache;
import com.powsybl.iidm.network.limitmodification.result.IdenticalLimitsContainer;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.limitreduction.computation.AbstractLimitsReducer;
import com.powsybl.security.limitreduction.computation.AbstractLimitsReducerCreator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractLimitReductionsApplier<P, L>
extends AbstractLimitsComputerWithCache<P, L> {
    private final List<LimitReduction> limitReductionList;
    private List<LimitReduction> reductionsForThisContingency = Collections.emptyList();

    protected AbstractLimitReductionsApplier(List<LimitReduction> limitReductionList) {
        this.limitReductionList = limitReductionList;
        this.computeReductionsForThisContingency(null);
    }

    protected Optional<LimitsContainer<L>> computeUncachedLimits(P processable, LimitType limitType, ThreeSides side, boolean monitoringOnly) {
        OriginalLimitsGetter<P, L> originalLimitsGetter = Objects.requireNonNull(this.getOriginalLimitsGetter());
        Optional<L> originalLimits = originalLimitsGetter.getLimits(processable, limitType, side);
        if (this.reductionsForThisContingency.isEmpty() || originalLimits.isEmpty()) {
            return originalLimits.map(IdenticalLimitsContainer::new);
        }
        AbstractLimitsReducerCreator<L, AbstractLimitsReducer<L>> limitsReducerCreator = Objects.requireNonNull(this.getLimitsReducerCreator());
        NetworkElement networkElement = Objects.requireNonNull(this.asNetworkElement(processable));
        AbstractLimitsReducer<L> limitsReducer = limitsReducerCreator.create(networkElement.getId(), originalLimits.get());
        this.updateLimitReducer(limitsReducer, networkElement, limitType, side, monitoringOnly);
        LimitsContainer<L> limitsContainer = limitsReducer.getLimits();
        this.putInCache(processable, limitType, side, monitoringOnly, limitsContainer);
        return Optional.of(limitsContainer);
    }

    protected abstract OriginalLimitsGetter<P, L> getOriginalLimitsGetter();

    protected abstract AbstractLimitsReducerCreator<L, AbstractLimitsReducer<L>> getLimitsReducerCreator();

    protected abstract NetworkElement asNetworkElement(P var1);

    private void updateLimitReducer(AbstractLimitsReducer<?> limitsReducer, NetworkElement networkElement, LimitType limitType, ThreeSides side, boolean monitoringOnly) {
        for (LimitReduction limitReduction : this.reductionsForThisContingency) {
            if (limitReduction.getLimitType() != limitType || limitReduction.isMonitoringOnly() != monitoringOnly || !AbstractLimitReductionsApplier.isNetworkElementAffectedByLimitReduction(networkElement, side, limitReduction)) continue;
            this.setLimitReductionsToLimitReducer(limitsReducer, limitReduction);
        }
    }

    public void setWorkingContingency(String contingencyId) {
        List<LimitReduction> reductionsForPreviousContingency = this.reductionsForThisContingency;
        this.computeReductionsForThisContingency(contingencyId);
        if (!this.reductionsForThisContingency.equals(reductionsForPreviousContingency)) {
            this.clearCache();
        }
    }

    private void computeReductionsForThisContingency(String contingencyId) {
        this.reductionsForThisContingency = this.limitReductionList.stream().filter(l -> AbstractLimitReductionsApplier.isContingencyInContingencyContext(l.getContingencyContext(), contingencyId)).toList();
    }

    private void setLimitReductionsToLimitReducer(AbstractLimitsReducer<?> limitsReducer, LimitReduction limitReduction) {
        if (AbstractLimitReductionsApplier.isPermanentLimitAffectedByLimitReduction(limitReduction)) {
            limitsReducer.setPermanentLimitReduction(limitReduction.getValue());
        }
        limitsReducer.getTemporaryLimitsAcceptableDurationStream().filter(acceptableDuration -> AbstractLimitReductionsApplier.isTemporaryLimitAffectedByLimitReduction(acceptableDuration, limitReduction)).forEach(acceptableDuration -> limitsReducer.setTemporaryLimitReduction(acceptableDuration, limitReduction.getValue()));
    }

    protected static boolean isContingencyInContingencyContext(ContingencyContext contingencyContext, String contingencyId) {
        return contingencyContext == null || contingencyContext.getContextType() == ContingencyContextType.ALL || contingencyContext.getContextType() == ContingencyContextType.NONE && contingencyId == null || contingencyContext.getContextType() == ContingencyContextType.ONLY_CONTINGENCIES && contingencyId != null || contingencyContext.getContextType() == ContingencyContextType.SPECIFIC && contingencyContext.getContingencyId().equals(contingencyId);
    }

    protected static boolean isNetworkElementAffectedByLimitReduction(NetworkElement networkElement, ThreeSides side, LimitReduction limitReduction) {
        NetworkElementVisitor networkElementVisitor = new NetworkElementVisitor(networkElement, side);
        List<NetworkElementCriterion> networkElementCriteria = limitReduction.getNetworkElementCriteria();
        return networkElementCriteria.isEmpty() || networkElementCriteria.stream().anyMatch(networkElementCriterion -> networkElementCriterion.accept(networkElementVisitor));
    }

    protected static boolean isPermanentLimitAffectedByLimitReduction(LimitReduction limitReduction) {
        return limitReduction.getDurationCriteria().isEmpty() || limitReduction.getDurationCriteria().stream().anyMatch(c -> c.getType().equals((Object)LimitDurationCriterion.LimitDurationType.PERMANENT));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isTemporaryLimitAffectedByLimitReduction(int temporaryLimitAcceptableDuration, LimitReduction limitReduction) {
        if (limitReduction.getDurationCriteria().isEmpty()) return true;
        if (!limitReduction.getDurationCriteria().stream().filter(limitDurationCriterion -> limitDurationCriterion.getType().equals((Object)LimitDurationCriterion.LimitDurationType.TEMPORARY)).map(AbstractTemporaryDurationCriterion.class::cast).anyMatch(c -> c.filter(temporaryLimitAcceptableDuration))) return false;
        return true;
    }

    protected static interface OriginalLimitsGetter<P, L> {
        public Optional<L> getLimits(P var1, LimitType var2, ThreeSides var3);
    }
}

