/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.ContingenciesProviders;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.SecurityAnalysisInputInterface;
import com.powsybl.security.execution.NetworkVariant;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractSecurityAnalysisInput<T extends AbstractSecurityAnalysisInput<T>>
implements SecurityAnalysisInputInterface {
    private final NetworkVariant networkVariant;
    private final Set<SecurityAnalysisInterceptor> interceptors;
    private LimitViolationFilter filter;
    private ContingenciesProvider contingencies;

    protected AbstractSecurityAnalysisInput(Network network, String variantId) {
        this(new NetworkVariant(network, variantId));
    }

    protected AbstractSecurityAnalysisInput(NetworkVariant networkVariant) {
        this.networkVariant = Objects.requireNonNull(networkVariant);
        this.interceptors = new HashSet<SecurityAnalysisInterceptor>();
        this.filter = new LimitViolationFilter();
        this.contingencies = ContingenciesProviders.emptyProvider();
    }

    public ContingenciesProvider getContingenciesProvider() {
        return this.contingencies;
    }

    public LimitViolationFilter getFilter() {
        return this.filter;
    }

    public Set<SecurityAnalysisInterceptor> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public T setContingencies(ContingenciesProvider contingencies) {
        Objects.requireNonNull(contingencies);
        this.contingencies = contingencies;
        return this.self();
    }

    public T addInterceptor(SecurityAnalysisInterceptor interceptor) {
        this.interceptors.add(Objects.requireNonNull(interceptor));
        return this.self();
    }

    public T setFilter(LimitViolationFilter filter) {
        this.filter = Objects.requireNonNull(filter);
        return this.self();
    }

    public NetworkVariant getNetworkVariant() {
        return this.networkVariant;
    }

    protected abstract T self();
}

