/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.google.common.io.ByteSource;
import com.powsybl.action.Action;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.execution.NetworkVariant;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractSecurityAnalysisExecutionInput<T extends AbstractSecurityAnalysisExecutionInput<T>> {
    private NetworkVariant networkVariant;
    private ByteSource contingenciesSource;
    private final List<String> resultExtensions = new ArrayList<String>();
    private final Set<LimitViolationType> violationTypes = EnumSet.noneOf(LimitViolationType.class);
    private boolean withLogs = false;
    private final List<OperatorStrategy> operatorStrategies = new ArrayList<OperatorStrategy>();
    private final List<Action> actions = new ArrayList<Action>();
    private final List<StateMonitor> monitors = new ArrayList<StateMonitor>();
    private final List<LimitReduction> limitReductions = new ArrayList<LimitReduction>();

    public Optional<ByteSource> getContingenciesSource() {
        return Optional.ofNullable(this.contingenciesSource);
    }

    public List<String> getResultExtensions() {
        return Collections.unmodifiableList(this.resultExtensions);
    }

    public Set<LimitViolationType> getViolationTypes() {
        return Collections.unmodifiableSet(this.violationTypes);
    }

    public NetworkVariant getNetworkVariant() {
        return this.networkVariant;
    }

    public List<OperatorStrategy> getOperatorStrategies() {
        return Collections.unmodifiableList(this.operatorStrategies);
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public List<StateMonitor> getMonitors() {
        return Collections.unmodifiableList(this.monitors);
    }

    public List<LimitReduction> getLimitReductions() {
        return Collections.unmodifiableList(this.limitReductions);
    }

    public boolean isWithLogs() {
        return this.withLogs;
    }

    public T setContingenciesSource(ByteSource contingenciesSource) {
        this.contingenciesSource = contingenciesSource;
        return this.self();
    }

    public T addResultExtension(String resultExtension) {
        this.resultExtensions.add(Objects.requireNonNull(resultExtension));
        return this.self();
    }

    public T addResultExtensions(Collection<String> resultExtensions) {
        this.resultExtensions.addAll(Objects.requireNonNull(resultExtensions));
        return this.self();
    }

    public T addViolationType(LimitViolationType violationType) {
        this.violationTypes.add(Objects.requireNonNull(violationType));
        return this.self();
    }

    public T addViolationTypes(Collection<LimitViolationType> violationTypes) {
        this.violationTypes.addAll(Objects.requireNonNull(violationTypes));
        return this.self();
    }

    public T addOperatorStrategies(List<OperatorStrategy> operatorStrategies) {
        this.operatorStrategies.addAll((Collection<OperatorStrategy>)Objects.requireNonNull(operatorStrategies));
        return this.self();
    }

    public T addActions(List<Action> actions) {
        this.actions.addAll((Collection<Action>)Objects.requireNonNull(actions));
        return this.self();
    }

    public T setNetworkVariant(Network network, String variantId) {
        this.networkVariant = new NetworkVariant(network, variantId);
        return this.self();
    }

    public T setOperatorStrategies(List<OperatorStrategy> operatorStrategies) {
        Objects.requireNonNull(operatorStrategies);
        this.operatorStrategies.clear();
        this.operatorStrategies.addAll(operatorStrategies);
        return this.self();
    }

    public T setActions(List<Action> actions) {
        Objects.requireNonNull(actions);
        this.actions.clear();
        this.actions.addAll(actions);
        return this.self();
    }

    public T setMonitors(List<StateMonitor> monitors) {
        Objects.requireNonNull(monitors);
        this.monitors.clear();
        this.monitors.addAll(monitors);
        return this.self();
    }

    public T setLimitReductions(List<LimitReduction> limitReductions) {
        Objects.requireNonNull(limitReductions);
        this.limitReductions.clear();
        this.limitReductions.addAll(limitReductions);
        return this.self();
    }

    public T setWithLogs(boolean withLogs) {
        this.withLogs = withLogs;
        return this.self();
    }

    protected abstract T self();
}

