/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.extensions.ActivePowerExtension;
import java.io.IOException;

@AutoService(value={ExtensionJsonSerializer.class})
public class ActivePowerExtensionSerializer
implements ExtensionJsonSerializer<LimitViolation, ActivePowerExtension> {
    public String getExtensionName() {
        return "ActivePower";
    }

    public String getCategoryName() {
        return "security-analysis";
    }

    public Class<? super ActivePowerExtension> getExtensionClass() {
        return ActivePowerExtension.class;
    }

    public void serialize(ActivePowerExtension extension, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (!Double.isNaN(extension.getPostContingencyValue())) {
            jsonGenerator.writeNumberField("preContingencyValue", extension.getPreContingencyValue());
            jsonGenerator.writeNumberField("postContingencyValue", extension.getPostContingencyValue());
        } else {
            jsonGenerator.writeNumberField("value", extension.getPreContingencyValue());
        }
        jsonGenerator.writeEndObject();
    }

    public ActivePowerExtension deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        double value = Double.NaN;
        double preContingencyValue = Double.NaN;
        double postContingencyValue = Double.NaN;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.currentName().equals("value")) {
                parser.nextToken();
                value = (Double)parser.readValueAs(Double.class);
                continue;
            }
            if (parser.currentName().equals("preContingencyValue")) {
                parser.nextToken();
                preContingencyValue = (Double)parser.readValueAs(Double.class);
                continue;
            }
            if (parser.currentName().equals("postContingencyValue")) {
                parser.nextToken();
                postContingencyValue = (Double)parser.readValueAs(Double.class);
                continue;
            }
            throw new PowsyblException("Unexpected field: " + parser.currentName());
        }
        if (!Double.isNaN(value)) {
            return new ActivePowerExtension(value);
        }
        return new ActivePowerExtension(preContingencyValue, postContingencyValue);
    }
}

