/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.ViolationLocation;
import java.io.IOException;
import java.util.Optional;

public class LimitViolationSerializer
extends StdSerializer<LimitViolation> {
    public LimitViolationSerializer() {
        super(LimitViolation.class);
    }

    public void serialize(LimitViolation limitViolation, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("subjectId", limitViolation.getSubjectId());
        Optional<ViolationLocation> violationLocation = limitViolation.getViolationLocation();
        if (violationLocation.isPresent()) {
            serializerProvider.defaultSerializeField("violationLocation", (Object)violationLocation.get(), jsonGenerator);
        }
        if (limitViolation.getSubjectName() != null) {
            jsonGenerator.writeStringField("subjectName", limitViolation.getSubjectName());
        }
        jsonGenerator.writeStringField("limitType", limitViolation.getLimitType().name());
        JsonUtil.writeOptionalStringField((JsonGenerator)jsonGenerator, (String)"limitName", (String)limitViolation.getLimitName());
        JsonUtil.writeOptionalIntegerField((JsonGenerator)jsonGenerator, (String)"acceptableDuration", (int)limitViolation.getAcceptableDuration());
        jsonGenerator.writeNumberField("limit", limitViolation.getLimit());
        jsonGenerator.writeNumberField("limitReduction", limitViolation.getLimitReduction());
        jsonGenerator.writeNumberField("value", limitViolation.getValue());
        JsonUtil.writeOptionalEnumField((JsonGenerator)jsonGenerator, (String)"side", (Enum)limitViolation.getSide());
        JsonUtil.writeExtensions((Extendable)limitViolation, (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider);
        jsonGenerator.writeEndObject();
    }
}

