/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.tools;

import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.converter.SecurityAnalysisResultExporters;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptors;
import com.powsybl.tools.Command;
import java.util.Arrays;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class SecurityAnalysisCommand
implements Command {
    public String getName() {
        return "security-analysis";
    }

    public String getTheme() {
        return "Computation";
    }

    public String getDescription() {
        return "Run security analysis";
    }

    public Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("case-file").desc("the case path").hasArg().argName("FILE").required().build());
        options.addOption(Option.builder().longOpt("parameters-file").desc("loadflow parameters as JSON file").hasArg().argName("FILE").build());
        options.addOption(Option.builder().longOpt("limit-types").desc("limit type filter (all if not set)").hasArg().argName("LIMIT-TYPES").build());
        options.addOption(Option.builder().longOpt("output-file").desc("the output path").hasArg().argName("FILE").build());
        options.addOption(Option.builder().longOpt("output-format").desc("the output format " + SecurityAnalysisResultExporters.getFormats()).hasArg().argName("FORMAT").build());
        options.addOption(Option.builder().longOpt("contingencies-file").desc("the contingencies path").hasArg().argName("FILE").build());
        options.addOption(Option.builder().longOpt("with-extensions").desc("the extension list to enable").hasArg().argName("EXTENSIONS").build());
        options.addOption(Option.builder().longOpt("task-count").desc("number of tasks used for parallelization").hasArg().argName("NTASKS").build());
        options.addOption(Option.builder().longOpt("task").desc("task identifier (task-index/task-count)").hasArg().argName("TASKID").build());
        options.addOption(Option.builder().longOpt("external").desc("external execution").build());
        options.addOption(ConversionToolUtils.createImportParametersFileOption());
        options.addOption(ConversionToolUtils.createImportParameterOption());
        options.addOption(Option.builder().longOpt("log-file").desc("log output path (.zip)").hasArg().argName("FILE").build());
        options.addOption(Option.builder().longOpt("monitoring-file").desc("monitoring file (.json) to get network's infos after computation").hasArg().argName("FILE").build());
        return options;
    }

    public String getUsageFooter() {
        return String.join((CharSequence)System.lineSeparator(), "Allowed LIMIT-TYPES values are " + Arrays.toString((Object[])LimitViolationType.values()), "Allowed EXTENSIONS values are " + SecurityAnalysisInterceptors.getExtensionNames());
    }
}

