/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.limitmodification.LimitsComputer;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.security.BusBreakerViolationLocation;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.NodeBreakerViolationLocation;
import com.powsybl.security.ViolationLocation;
import com.powsybl.security.detectors.LoadingLimitType;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LimitViolationDetection {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitViolationDetection.class);

    private LimitViolationDetection() {
    }

    public static void checkAll(Network network, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        network.getBranchStream().forEach(b -> LimitViolationDetection.checkCurrent(b, currentLimitTypes, limitsComputer, consumer));
        network.getThreeWindingsTransformerStream().forEach(t -> LimitViolationDetection.checkCurrent(t, currentLimitTypes, limitsComputer, consumer));
        network.getVoltageLevelStream().flatMap(vl -> vl.getBusView().getBusStream()).forEach(b -> LimitViolationDetection.checkVoltage(b, consumer));
        network.getVoltageAngleLimitsStream().forEach(valOk -> LimitViolationDetection.checkVoltageAngle(valOk, consumer));
    }

    public static void checkAllDc(Network network, double dcPowerFactor, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        network.getBranchStream().forEach(b -> LimitViolationDetection.checkCurrentDc(b, dcPowerFactor, currentLimitTypes, limitsComputer, consumer));
        network.getThreeWindingsTransformerStream().forEach(b -> LimitViolationDetection.checkCurrentDc(b, dcPowerFactor, currentLimitTypes, limitsComputer, consumer));
        network.getVoltageAngleLimitsStream().forEach(valOk -> LimitViolationDetection.checkVoltageAngle(valOk, consumer));
    }

    private static void checkCurrent(Branch<?> branch, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        LimitViolationDetection.checkCurrent(branch, TwoSides.ONE, currentLimitTypes, limitsComputer, consumer);
        LimitViolationDetection.checkCurrent(branch, TwoSides.TWO, currentLimitTypes, limitsComputer, consumer);
    }

    private static void checkCurrent(Branch<?> branch, TwoSides side, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        LimitViolationDetection.checkLimitViolation(branch, side, branch.getTerminal(side).getI(), LimitType.CURRENT, currentLimitTypes, limitsComputer, consumer);
    }

    private static void checkCurrentDc(Branch<?> branch, double dcPowerFactor, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        LimitViolationDetection.checkCurrentDc(branch, TwoSides.ONE, dcPowerFactor, currentLimitTypes, limitsComputer, consumer);
        LimitViolationDetection.checkCurrentDc(branch, TwoSides.TWO, dcPowerFactor, currentLimitTypes, limitsComputer, consumer);
    }

    private static void checkCurrentDc(Branch<?> branch, TwoSides side, double dcPowerFactor, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        double i = LimitViolationDetection.getTerminalIOrAnApproximation(branch.getTerminal(side), dcPowerFactor);
        LimitViolationDetection.checkLimitViolation(branch, side, i, LimitType.CURRENT, currentLimitTypes, limitsComputer, consumer);
    }

    public static double getTerminalIOrAnApproximation(Terminal terminal, double dcPowerFactor) {
        return Double.isNaN(terminal.getI()) ? 1000.0 * terminal.getP() / (terminal.getVoltageLevel().getNominalV() * Math.sqrt(3.0) * dcPowerFactor) : terminal.getI();
    }

    static void checkLimitViolation(Branch<?> branch, TwoSides side, double value, LimitType type, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        Overload overload;
        boolean overloadOnTemporary = false;
        if (currentLimitTypes.contains((Object)LoadingLimitType.TATL) && (overload = LimitViolationUtils.checkTemporaryLimits(branch, (TwoSides)side, limitsComputer, (double)value, (LimitType)type)) != null) {
            consumer.accept(new LimitViolation(branch.getId(), branch.getOptionalName().orElse("null"), LimitViolationDetection.toLimitViolationType(type), overload.getPreviousLimitName(), overload.getTemporaryLimit().getAcceptableDuration(), overload.getPreviousLimit(), overload.getLimitReductionCoefficient(), value, side));
            overloadOnTemporary = true;
        }
        if (!overloadOnTemporary && currentLimitTypes.contains((Object)LoadingLimitType.PATL) && (overload = LimitViolationUtils.checkPermanentLimit(branch, (TwoSides)side, (double)value, (LimitType)type, limitsComputer)).isOverload()) {
            double limit = branch.getLimits(type, side).map(LoadingLimits::getPermanentLimit).orElseThrow(PowsyblException::new);
            consumer.accept(new LimitViolation(branch.getId(), (String)branch.getOptionalName().orElse(null), LimitViolationDetection.toLimitViolationType(type), "permanent", Integer.MAX_VALUE, limit, overload.limitReductionValue(), value, side));
        }
    }

    private static void checkCurrent(ThreeWindingsTransformer transformer, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        LimitViolationDetection.checkCurrent(transformer, ThreeSides.ONE, currentLimitTypes, limitsComputer, consumer);
        LimitViolationDetection.checkCurrent(transformer, ThreeSides.TWO, currentLimitTypes, limitsComputer, consumer);
        LimitViolationDetection.checkCurrent(transformer, ThreeSides.THREE, currentLimitTypes, limitsComputer, consumer);
    }

    private static void checkCurrent(ThreeWindingsTransformer transformer, ThreeSides side, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        LimitViolationDetection.checkLimitViolation(transformer, side, transformer.getTerminal(side).getI(), LimitType.CURRENT, currentLimitTypes, limitsComputer, consumer);
    }

    private static void checkCurrentDc(ThreeWindingsTransformer transformer, double dcPowerFactor, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        LimitViolationDetection.checkCurrentDc(transformer, ThreeSides.ONE, dcPowerFactor, currentLimitTypes, limitsComputer, consumer);
        LimitViolationDetection.checkCurrentDc(transformer, ThreeSides.TWO, dcPowerFactor, currentLimitTypes, limitsComputer, consumer);
        LimitViolationDetection.checkCurrentDc(transformer, ThreeSides.THREE, dcPowerFactor, currentLimitTypes, limitsComputer, consumer);
    }

    private static void checkCurrentDc(ThreeWindingsTransformer transformer, ThreeSides side, double dcPowerFactor, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        double i = LimitViolationDetection.getTerminalIOrAnApproximation(transformer.getTerminal(side), dcPowerFactor);
        LimitViolationDetection.checkLimitViolation(transformer, side, i, LimitType.CURRENT, currentLimitTypes, limitsComputer, consumer);
    }

    static void checkLimitViolation(ThreeWindingsTransformer transformer, ThreeSides side, double value, LimitType type, Set<LoadingLimitType> currentLimitTypes, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, Consumer<LimitViolation> consumer) {
        Overload overload;
        boolean overloadOnTemporary = false;
        if (currentLimitTypes.contains((Object)LoadingLimitType.TATL) && (overload = LimitViolationUtils.checkTemporaryLimits((ThreeWindingsTransformer)transformer, (ThreeSides)side, limitsComputer, (double)value, (LimitType)type)) != null) {
            consumer.accept(new LimitViolation(transformer.getId(), (String)transformer.getOptionalName().orElse(null), LimitViolationDetection.toLimitViolationType(type), overload.getPreviousLimitName(), overload.getTemporaryLimit().getAcceptableDuration(), overload.getPreviousLimit(), overload.getLimitReductionCoefficient(), value, side));
            overloadOnTemporary = true;
        }
        if (!overloadOnTemporary && currentLimitTypes.contains((Object)LoadingLimitType.PATL) && (overload = LimitViolationUtils.checkPermanentLimit((ThreeWindingsTransformer)transformer, (ThreeSides)side, limitsComputer, (double)value, (LimitType)type)).isOverload()) {
            double limit = transformer.getLeg(side).getLimits(type).map(LoadingLimits::getPermanentLimit).orElseThrow(PowsyblException::new);
            consumer.accept(new LimitViolation(transformer.getId(), (String)transformer.getOptionalName().orElse(null), LimitViolationDetection.toLimitViolationType(type), "permanent", Integer.MAX_VALUE, limit, overload.limitReductionValue(), value, side));
        }
    }

    private static void checkVoltage(Bus bus, Consumer<LimitViolation> consumer) {
        double value = bus.getV();
        LimitViolationDetection.checkVoltage(bus, value, consumer);
    }

    static void checkVoltage(Bus bus, double value, Consumer<LimitViolation> consumer) {
        VoltageLevel vl = bus.getVoltageLevel();
        if (!Double.isNaN(vl.getLowVoltageLimit()) && value <= vl.getLowVoltageLimit()) {
            consumer.accept(new LimitViolation(vl.getId(), vl.getOptionalName().orElse(null), LimitViolationType.LOW_VOLTAGE, vl.getLowVoltageLimit(), 1.0, value, LimitViolationDetection.createViolationLocation(bus)));
        }
        if (!Double.isNaN(vl.getHighVoltageLimit()) && value >= vl.getHighVoltageLimit()) {
            consumer.accept(new LimitViolation(vl.getId(), vl.getOptionalName().orElse(null), LimitViolationType.HIGH_VOLTAGE, vl.getHighVoltageLimit(), 1.0, value, LimitViolationDetection.createViolationLocation(bus)));
        }
    }

    public static LimitViolationType toLimitViolationType(LimitType type) {
        return switch (type) {
            case LimitType.ACTIVE_POWER -> LimitViolationType.ACTIVE_POWER;
            case LimitType.APPARENT_POWER -> LimitViolationType.APPARENT_POWER;
            case LimitType.CURRENT -> LimitViolationType.CURRENT;
            default -> throw new UnsupportedOperationException(String.format("Unsupported conversion for %s from limit type to limit violation type.", type.name()));
        };
    }

    private static void checkVoltageAngle(VoltageAngleLimit voltageAngleLimit, Consumer<LimitViolation> consumer) {
        Bus referenceBus = voltageAngleLimit.getTerminalFrom().getBusView().getBus();
        Bus otherBus = voltageAngleLimit.getTerminalTo().getBusView().getBus();
        if (referenceBus != null && otherBus != null && referenceBus.getConnectedComponent().getNum() == otherBus.getConnectedComponent().getNum() && referenceBus.getSynchronousComponent().getNum() == otherBus.getSynchronousComponent().getNum()) {
            double voltageAngleDifference = otherBus.getAngle() - referenceBus.getAngle();
            LimitViolationDetection.checkVoltageAngle(voltageAngleLimit, voltageAngleDifference, consumer);
        }
    }

    static void checkVoltageAngle(VoltageAngleLimit voltageAngleLimit, double value, Consumer<LimitViolation> consumer) {
        if (Double.isNaN(value)) {
            return;
        }
        voltageAngleLimit.getLowLimit().ifPresent(lowLimit -> {
            if (value <= lowLimit) {
                consumer.accept(new LimitViolation(voltageAngleLimit.getId(), LimitViolationType.LOW_VOLTAGE_ANGLE, lowLimit, 1.0, value));
            }
        });
        voltageAngleLimit.getHighLimit().ifPresent(highLimit -> {
            if (value >= highLimit) {
                consumer.accept(new LimitViolation(voltageAngleLimit.getId(), LimitViolationType.HIGH_VOLTAGE_ANGLE, highLimit, 1.0, value));
            }
        });
    }

    public static ViolationLocation createViolationLocation(Bus bus) {
        VoltageLevel vl = bus.getVoltageLevel();
        if (vl.getTopologyKind() == TopologyKind.NODE_BREAKER) {
            List<Integer> nodes = ((Set)Networks.getNodesByBus((VoltageLevel)vl).get(bus.getId())).stream().toList();
            return new NodeBreakerViolationLocation(vl.getId(), nodes);
        }
        try {
            List<String> configuredBusIds = vl.getBusBreakerView().getBusStreamFromBusViewBusId(bus.getId()).map(Identifiable::getId).sorted().toList();
            return new BusBreakerViolationLocation(configuredBusIds);
        }
        catch (Exception e) {
            LOGGER.error("Error generating ViolationLocation", (Throwable)e);
            return null;
        }
    }
}

