/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.SecurityAnalysisResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SecurityAnalysisResultMerger {
    private static final LimitViolationsResult FAILED_N_STATE_RESULT = new LimitViolationsResult(Collections.emptyList());
    public static final SecurityAnalysisResult FAILED_SECURITY_ANALYSIS_RESULT = new SecurityAnalysisResult(FAILED_N_STATE_RESULT, LoadFlowResult.ComponentResult.Status.FAILED, Collections.emptyList());

    public static SecurityAnalysisResult merge(SecurityAnalysisResult[] results) {
        Objects.requireNonNull(results);
        for (SecurityAnalysisResult subResult : results) {
            if (subResult.getPreContingencyResult().getStatus() == LoadFlowResult.ComponentResult.Status.CONVERGED) continue;
            return FAILED_SECURITY_ANALYSIS_RESULT;
        }
        return new SecurityAnalysisResult(results[0].getPreContingencyLimitViolationsResult(), results[0].getPreContingencyResult().getStatus(), Arrays.stream(results).flatMap(result -> result.getPostContingencyResults().stream()).collect(Collectors.toList())).setNetworkMetadata(results[0].getNetworkMetadata());
    }

    public static SecurityAnalysisResult merge(Collection<SecurityAnalysisResult> results) {
        Objects.requireNonNull(results);
        return SecurityAnalysisResultMerger.merge(results.toArray(new SecurityAnalysisResult[0]));
    }

    private SecurityAnalysisResultMerger() {
    }
}

