/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.detectors;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationDetection;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.detectors.AbstractContingencyBlindDetector;
import com.powsybl.security.detectors.LoadingLimitType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class DefaultLimitViolationDetector
extends AbstractContingencyBlindDetector {
    private final double limitReductionValue;
    private final Set<LoadingLimitType> currentLimitTypes;

    public DefaultLimitViolationDetector(double limitReductionValue, Collection<LoadingLimitType> currentLimitTypes) {
        if (limitReductionValue <= 0.0) {
            throw new IllegalArgumentException("Bad limit reduction " + limitReductionValue);
        }
        this.limitReductionValue = limitReductionValue;
        this.currentLimitTypes = EnumSet.copyOf(Objects.requireNonNull(currentLimitTypes));
    }

    public DefaultLimitViolationDetector(Collection<LoadingLimitType> currentLimitTypes) {
        this(1.0, currentLimitTypes);
    }

    public DefaultLimitViolationDetector() {
        this(EnumSet.allOf(LoadingLimitType.class));
    }

    @Override
    public void checkCurrent(Branch branch, TwoSides side, double value, Consumer<LimitViolation> consumer) {
        this.checkLimitViolation(branch, side, value, consumer, LimitType.CURRENT);
    }

    @Override
    public void checkCurrent(ThreeWindingsTransformer transformer, ThreeSides side, double value, Consumer<LimitViolation> consumer) {
        this.checkLimitViolation(transformer, side, value, consumer, LimitType.CURRENT);
    }

    @Override
    public void checkActivePower(Branch branch, TwoSides side, double value, Consumer<LimitViolation> consumer) {
        this.checkLimitViolation(branch, side, value, consumer, LimitType.ACTIVE_POWER);
    }

    @Override
    public void checkActivePower(ThreeWindingsTransformer transformer, ThreeSides side, double value, Consumer<LimitViolation> consumer) {
        this.checkLimitViolation(transformer, side, value, consumer, LimitType.ACTIVE_POWER);
    }

    @Override
    public void checkApparentPower(Branch branch, TwoSides side, double value, Consumer<LimitViolation> consumer) {
        this.checkLimitViolation(branch, side, value, consumer, LimitType.APPARENT_POWER);
    }

    @Override
    public void checkApparentPower(ThreeWindingsTransformer transformer, ThreeSides side, double value, Consumer<LimitViolation> consumer) {
        this.checkLimitViolation(transformer, side, value, consumer, LimitType.APPARENT_POWER);
    }

    @Override
    public void checkVoltage(Bus bus, double value, Consumer<LimitViolation> consumer) {
        VoltageLevel vl = bus.getVoltageLevel();
        if (!Double.isNaN(vl.getLowVoltageLimit()) && value <= vl.getLowVoltageLimit()) {
            consumer.accept(new LimitViolation(vl.getId(), vl.getOptionalName().orElse(null), LimitViolationType.LOW_VOLTAGE, vl.getLowVoltageLimit(), this.limitReductionValue, value, LimitViolationDetection.createViolationLocation(bus)));
        }
        if (!Double.isNaN(vl.getHighVoltageLimit()) && value >= vl.getHighVoltageLimit()) {
            consumer.accept(new LimitViolation(vl.getId(), vl.getOptionalName().orElse(null), LimitViolationType.HIGH_VOLTAGE, vl.getHighVoltageLimit(), this.limitReductionValue, value, LimitViolationDetection.createViolationLocation(bus)));
        }
    }

    @Override
    public void checkVoltageAngle(VoltageAngleLimit voltageAngleLimit, double value, Consumer<LimitViolation> consumer) {
        if (Double.isNaN(value)) {
            return;
        }
        voltageAngleLimit.getLowLimit().ifPresent(lowLimit -> {
            if (value <= lowLimit) {
                consumer.accept(new LimitViolation(voltageAngleLimit.getId(), LimitViolationType.LOW_VOLTAGE_ANGLE, lowLimit, this.limitReductionValue, value));
            }
        });
        voltageAngleLimit.getHighLimit().ifPresent(highLimit -> {
            if (value >= highLimit) {
                consumer.accept(new LimitViolation(voltageAngleLimit.getId(), LimitViolationType.HIGH_VOLTAGE_ANGLE, highLimit, this.limitReductionValue, value));
            }
        });
    }

    public void checkLimitViolation(Branch branch, TwoSides side, double value, Consumer<LimitViolation> consumer, LimitType type) {
        boolean noOverloadOnTemporary = true;
        if (this.currentLimitTypes.contains((Object)LoadingLimitType.TATL)) {
            noOverloadOnTemporary = this.checkTemporary(branch, side, this.limitReductionValue, value, consumer, type);
        }
        if (noOverloadOnTemporary && this.currentLimitTypes.contains((Object)LoadingLimitType.PATL)) {
            this.checkPermanentLimit(branch, side, this.limitReductionValue, value, consumer, type);
        }
    }

    public void checkLimitViolation(ThreeWindingsTransformer transformer, ThreeSides side, double value, Consumer<LimitViolation> consumer, LimitType type) {
        boolean noOverloadOnTemporary = true;
        if (this.currentLimitTypes.contains((Object)LoadingLimitType.TATL)) {
            noOverloadOnTemporary = this.checkTemporary(transformer, side, this.limitReductionValue, value, consumer, type);
        }
        if (noOverloadOnTemporary && this.currentLimitTypes.contains((Object)LoadingLimitType.PATL)) {
            this.checkPermanentLimit(transformer, side, this.limitReductionValue, value, consumer, type);
        }
    }
}

