/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.powsybl.commons.config.ConfigurationException;
import com.powsybl.commons.config.PlatformConfig;
import java.util.Objects;

public class ExternalSecurityAnalysisConfig {
    private static final boolean DEFAULT_DEBUG = false;
    private static final String DEFAULT_COMMAND = "itools";
    private final boolean debug;
    private final String itoolsCommand;

    public ExternalSecurityAnalysisConfig() {
        this(false, DEFAULT_COMMAND);
    }

    public ExternalSecurityAnalysisConfig(boolean debug) {
        this(debug, DEFAULT_COMMAND);
    }

    public ExternalSecurityAnalysisConfig(boolean debug, String itoolsCommand) {
        this.debug = debug;
        Objects.requireNonNull(itoolsCommand);
        if (itoolsCommand.isEmpty()) {
            throw new ConfigurationException("itools command must not be empty.");
        }
        this.itoolsCommand = itoolsCommand;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getItoolsCommand() {
        return this.itoolsCommand;
    }

    public static ExternalSecurityAnalysisConfig load() {
        return ExternalSecurityAnalysisConfig.load(PlatformConfig.defaultConfig());
    }

    public static ExternalSecurityAnalysisConfig load(PlatformConfig platformConfig) {
        return platformConfig.getOptionalModuleConfig("external-security-analysis-config").map(module -> {
            boolean debug = module.getBooleanProperty("debug", false);
            String itoolsCommand = module.getStringProperty("itools-command", DEFAULT_COMMAND);
            return new ExternalSecurityAnalysisConfig(debug, itoolsCommand);
        }).orElseGet(() -> new ExternalSecurityAnalysisConfig(false, DEFAULT_COMMAND));
    }
}

