/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Suppliers;
import com.powsybl.action.json.ActionJsonModule;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.NetworkMetadata;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.json.SecurityAnalysisJsonModule;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class SecurityAnalysisResultDeserializer
extends StdDeserializer<SecurityAnalysisResult> {
    private static final String CONTEXT_NAME = "SecurityAnalysisResult";
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"security-analysis"));
    public static final String SOURCE_VERSION_ATTRIBUTE = "sourceVersionAttribute";

    public SecurityAnalysisResultDeserializer() {
        super(SecurityAnalysisResult.class);
    }

    public SecurityAnalysisResult deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String version = null;
        NetworkMetadata networkMetadata = null;
        LimitViolationsResult limitViolationsResult = null;
        List postContingencyResults = Collections.emptyList();
        List extensions = Collections.emptyList();
        PreContingencyResult preContingencyResult = null;
        List operatorStrategyResults = Collections.emptyList();
        block16: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    JsonUtil.setSourceVersion((DatabindContext)ctx, (String)version, (String)SOURCE_VERSION_ATTRIBUTE);
                    ctx.setAttribute((Object)"violationLocationSupport", (Object)(version.compareTo("1.7") >= 0 ? 1 : 0));
                    continue block16;
                }
                case "network": {
                    parser.nextToken();
                    networkMetadata = (NetworkMetadata)((Object)JsonUtil.readValue((DeserializationContext)ctx, (JsonParser)parser, NetworkMetadata.class));
                    continue block16;
                }
                case "preContingencyResult": {
                    parser.nextToken();
                    if (version != null && version.equals("1.0")) {
                        limitViolationsResult = (LimitViolationsResult)JsonUtil.readValue((DeserializationContext)ctx, (JsonParser)parser, LimitViolationsResult.class);
                        continue block16;
                    }
                    preContingencyResult = (PreContingencyResult)JsonUtil.readValue((DeserializationContext)ctx, (JsonParser)parser, PreContingencyResult.class);
                    continue block16;
                }
                case "postContingencyResults": {
                    parser.nextToken();
                    postContingencyResults = JsonUtil.readList((DeserializationContext)ctx, (JsonParser)parser, PostContingencyResult.class);
                    continue block16;
                }
                case "operatorStrategyResults": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: operatorStrategyResults", (String)version, (String)"1.2");
                    parser.nextToken();
                    operatorStrategyResults = JsonUtil.readList((DeserializationContext)ctx, (JsonParser)parser, OperatorStrategyResult.class);
                    continue block16;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)ctx, SUPPLIER.get());
                    continue block16;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        SecurityAnalysisResult result = null;
        if (preContingencyResult == null) {
            LoadFlowResult.ComponentResult.Status status = null;
            status = limitViolationsResult != null && version.equals("1.0") ? (limitViolationsResult.isComputationOk() ? LoadFlowResult.ComponentResult.Status.CONVERGED : LoadFlowResult.ComponentResult.Status.FAILED) : LoadFlowResult.ComponentResult.Status.CONVERGED;
            result = new SecurityAnalysisResult(limitViolationsResult, status, postContingencyResults, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), operatorStrategyResults);
        } else {
            result = new SecurityAnalysisResult(preContingencyResult, postContingencyResults, operatorStrategyResults);
        }
        result.setNetworkMetadata(networkMetadata);
        SUPPLIER.get().addExtensions((Extendable)result, (Collection)extensions);
        return result;
    }

    public static SecurityAnalysisResult read(Path jsonFile) {
        SecurityAnalysisResult securityAnalysisResult;
        block8: {
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                securityAnalysisResult = SecurityAnalysisResultDeserializer.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return securityAnalysisResult;
    }

    public static SecurityAnalysisResult read(InputStream is) {
        Objects.requireNonNull(is);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper().registerModule((Module)new SecurityAnalysisJsonModule()).registerModule((Module)new ActionJsonModule());
        try {
            return (SecurityAnalysisResult)((Object)objectMapper.readValue(is, SecurityAnalysisResult.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

