/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.security.ViolationLocation;
import java.util.List;
import java.util.Objects;

public class BusBreakerViolationLocation
implements ViolationLocation {
    private final List<String> busIds;

    public BusBreakerViolationLocation(List<String> busIds) {
        this.busIds = Objects.requireNonNull(busIds, "busIds should not be null.");
    }

    public List<String> getBusIds() {
        return this.busIds;
    }

    @Override
    public ViolationLocation.Type getType() {
        return ViolationLocation.Type.BUS_BREAKER;
    }

    public String toString() {
        return "BusBreakerViolationLocation{busIds='" + this.busIds + "'}";
    }

    @Override
    public ViolationLocation.BusView getBusView(Network network) {
        return () -> this.busIds.stream().map(id -> network.getBusBreakerView().getBus(id)).filter(b -> b.getConnectedTerminalCount() > 0).map(b -> ((Terminal)b.getConnectedTerminals().iterator().next()).getBusView().getBus()).distinct();
    }

    @Override
    public ViolationLocation.BusView getBusBreakerView(Network network) {
        return () -> this.busIds.stream().map(id -> network.getBusBreakerView().getBus(id));
    }
}

