/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.ViolationLocation;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class LimitViolation
extends AbstractExtendable<LimitViolation> {
    private final String subjectId;
    private final String subjectName;
    private final LimitViolationType limitType;
    private final double limit;
    private final String limitName;
    private final int acceptableDuration;
    private final double limitReduction;
    private final double value;
    private final ThreeSides side;
    private final ViolationLocation voltageLocation;

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, double limitReduction, double value, @Nullable ThreeSides side, @Nullable ViolationLocation voltageLocation) {
        this.subjectId = Objects.requireNonNull(subjectId);
        this.subjectName = subjectName;
        this.limitType = Objects.requireNonNull(limitType);
        this.limitName = limitName;
        this.acceptableDuration = acceptableDuration;
        this.limit = limit;
        this.limitReduction = limitReduction;
        this.value = value;
        this.side = LimitViolation.checkSide(limitType, side);
        this.voltageLocation = voltageLocation;
    }

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, double limitReduction, double value, @Nullable ThreeSides side) {
        this(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, side, null);
    }

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, double limitReduction, double value) {
        this(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, (ThreeSides)null);
    }

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, double limitReduction, double value, TwoSides side) {
        this(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, Objects.requireNonNull(side).toThreeSides());
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, String limitName, int acceptableDuration, double limit, double limitReduction, double value, TwoSides side) {
        this(subjectId, null, limitType, limitName, acceptableDuration, limit, limitReduction, value, Objects.requireNonNull(side).toThreeSides());
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, String limitName, int acceptableDuration, double limit, double limitReduction, double value) {
        this(subjectId, null, limitType, limitName, acceptableDuration, limit, limitReduction, value, (ThreeSides)null);
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, double limit, double limitReduction, double value, ViolationLocation voltageLocation) {
        this(subjectId, null, limitType, null, Integer.MAX_VALUE, limit, limitReduction, value, null, voltageLocation);
    }

    public LimitViolation(String subjectId, String subjectName, LimitViolationType limitType, double limit, double limitReduction, double value) {
        this(subjectId, subjectName, limitType, null, Integer.MAX_VALUE, limit, limitReduction, value, null, null);
    }

    public LimitViolation(String subjectId, String subjectName, LimitViolationType limitType, double limit, double limitReduction, double value, ViolationLocation voltageLocation) {
        this(subjectId, subjectName, limitType, null, Integer.MAX_VALUE, limit, limitReduction, value, null, voltageLocation);
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, double limit, double limitReduction, double value) {
        this(subjectId, null, limitType, null, Integer.MAX_VALUE, limit, limitReduction, value, null, null);
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public Optional<ViolationLocation> getViolationLocation() {
        return Optional.ofNullable(this.voltageLocation);
    }

    public @Nullable String getSubjectName() {
        return this.subjectName;
    }

    public LimitViolationType getLimitType() {
        return this.limitType;
    }

    public double getLimit() {
        return this.limit;
    }

    public @Nullable String getLimitName() {
        return this.limitName;
    }

    public int getAcceptableDuration() {
        return this.acceptableDuration;
    }

    public double getLimitReduction() {
        return this.limitReduction;
    }

    public double getValue() {
        return this.value;
    }

    public TwoSides getSideAsTwoSides() {
        return Objects.requireNonNull(this.side).toTwoSides();
    }

    public @Nullable ThreeSides getSide() {
        return this.side;
    }

    private static ThreeSides checkSide(LimitViolationType limitType, ThreeSides side) {
        if (limitType == LimitViolationType.ACTIVE_POWER || limitType == LimitViolationType.APPARENT_POWER || limitType == LimitViolationType.CURRENT) {
            return Objects.requireNonNull(side);
        }
        return null;
    }

    public String toString() {
        return "Subject id: " + this.subjectId + ", Subject name: " + this.subjectName + ", limitType: " + this.limitType + ", limit: " + this.limit + ", limitName: " + this.limitName + ", acceptableDuration: " + this.acceptableDuration + ", limitReduction: " + this.limitReduction + ", value: " + this.value + ", side: " + this.side + ", voltageLocation: " + this.voltageLocation;
    }
}

