/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationHelper;
import com.powsybl.security.LimitViolationType;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LimitViolationFilter {
    private static final Set<LimitViolationType> DEFAULT_VIOLATION_TYPES = EnumSet.allOf(LimitViolationType.class);
    private static final double DEFAULT_MIN_BASE_VOLTAGE = 0.0;
    private static final Set<Country> DEFAULT_COUNTRIES = null;
    private Set<LimitViolationType> violationTypes;
    private double minBaseVoltage;
    private Set<Country> countries;

    private static Set<LimitViolationType> checkViolationTypes(Set<LimitViolationType> violationTypes) {
        if (violationTypes == null) {
            return DEFAULT_VIOLATION_TYPES;
        }
        if (!violationTypes.isEmpty()) {
            return violationTypes;
        }
        throw new IllegalArgumentException("Bad violation types filter");
    }

    private static double checkMinBaseVoltage(double minBaseVoltage) {
        if (Double.isNaN(minBaseVoltage) || minBaseVoltage < 0.0) {
            throw new IllegalArgumentException("Bad min base voltage filter " + minBaseVoltage);
        }
        return minBaseVoltage;
    }

    public static LimitViolationFilter load() {
        return LimitViolationFilter.load(PlatformConfig.defaultConfig());
    }

    public static LimitViolationFilter load(PlatformConfig platformConfig) {
        return platformConfig.getOptionalModuleConfig("limit-violation-default-filter").map(moduleConfig -> {
            LimitViolationFilter filter = new LimitViolationFilter();
            filter.setViolationTypes(moduleConfig.getEnumSetProperty("violationTypes", LimitViolationType.class, DEFAULT_VIOLATION_TYPES));
            filter.setMinBaseVoltage(moduleConfig.getDoubleProperty("minBaseVoltage", 0.0));
            filter.setCountries(moduleConfig.getEnumSetProperty("countries", Country.class, DEFAULT_COUNTRIES));
            return filter;
        }).orElseGet(LimitViolationFilter::new);
    }

    public LimitViolationFilter(Set<LimitViolationType> violationTypes) {
        this(violationTypes, 0.0, DEFAULT_COUNTRIES);
    }

    public LimitViolationFilter() {
        this(DEFAULT_VIOLATION_TYPES, 0.0, DEFAULT_COUNTRIES);
    }

    public LimitViolationFilter(Set<LimitViolationType> violationTypes, double minBaseVoltage) {
        this(violationTypes, minBaseVoltage, DEFAULT_COUNTRIES);
    }

    public LimitViolationFilter(Set<LimitViolationType> violationTypes, double minBaseVoltage, Set<Country> countries) {
        this.violationTypes = LimitViolationFilter.checkViolationTypes(violationTypes);
        this.minBaseVoltage = LimitViolationFilter.checkMinBaseVoltage(minBaseVoltage);
        this.countries = countries;
    }

    public Set<LimitViolationType> getViolationTypes() {
        return this.violationTypes;
    }

    public LimitViolationFilter setViolationTypes(Set<LimitViolationType> violationTypes) {
        this.violationTypes = LimitViolationFilter.checkViolationTypes(violationTypes);
        return this;
    }

    public double getMinBaseVoltage() {
        return this.minBaseVoltage;
    }

    public LimitViolationFilter setMinBaseVoltage(double minBaseVoltage) {
        this.minBaseVoltage = LimitViolationFilter.checkMinBaseVoltage(minBaseVoltage);
        return this;
    }

    public Set<Country> getCountries() {
        return Optional.ofNullable(this.countries).orElse(EnumSet.allOf(Country.class));
    }

    public LimitViolationFilter setCountries(Set<Country> countries) {
        this.countries = countries;
        return this;
    }

    public List<LimitViolation> apply(List<LimitViolation> violations, Network network) {
        Objects.requireNonNull(violations);
        Objects.requireNonNull(network);
        return violations.stream().filter(violation -> this.accept(violation.getLimitType())).filter(violation -> this.accept(LimitViolationHelper.getNominalVoltage(violation, network))).filter(violation -> this.accept((Country)LimitViolationHelper.getCountry(violation, network).orElse(null))).collect(Collectors.toList());
    }

    private boolean accept(Country country) {
        if (this.countries == null) {
            return true;
        }
        if (this.countries.isEmpty()) {
            return country == null;
        }
        return country != null && this.countries.contains(country);
    }

    private boolean accept(double baseVoltage) {
        return Double.isNaN(baseVoltage) || baseVoltage >= this.minBaseVoltage;
    }

    private boolean accept(LimitViolationType limitViolationType) {
        return this.violationTypes.contains((Object)limitViolationType);
    }
}

