/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import java.util.Objects;

public abstract class AbstractForwardedSecurityAnalysisExecution {
    protected final ExternalSecurityAnalysisConfig config;
    protected Integer forwardedTaskCount;

    protected AbstractForwardedSecurityAnalysisExecution(ExternalSecurityAnalysisConfig config) {
        this(config, null);
    }

    protected AbstractForwardedSecurityAnalysisExecution(ExternalSecurityAnalysisConfig config, Integer forwardedTaskCount) {
        this.config = Objects.requireNonNull(config);
        this.forwardedTaskCount = AbstractForwardedSecurityAnalysisExecution.checkForwardedTaskCount(forwardedTaskCount);
    }

    private static Integer checkForwardedTaskCount(Integer count) {
        Preconditions.checkArgument((count == null || count > 0 ? 1 : 0) != 0, (Object)"Forwarded task count must be positive.");
        return count;
    }
}

