/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.powsybl.computation.Command;
import com.powsybl.computation.CommandExecution;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.distributed.AbstractSecurityAnalysisExecutionHandler;
import com.powsybl.security.distributed.SecurityAnalysisCommandOptions;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import java.nio.file.Path;

public class SecurityAnalysisExecutionHandler<R>
extends AbstractSecurityAnalysisExecutionHandler<R, SecurityAnalysisExecutionInput, SecurityAnalysisCommandOptions> {
    public SecurityAnalysisExecutionHandler(AbstractSecurityAnalysisExecutionHandler.ResultReader<R> reader, AbstractSecurityAnalysisExecutionHandler.OptionsCustomizer<SecurityAnalysisCommandOptions> optionsCustomizer, AbstractSecurityAnalysisExecutionHandler.ExceptionHandler exceptionHandler, int executionCount, SecurityAnalysisExecutionInput input) {
        super(reader, optionsCustomizer, exceptionHandler, executionCount, input);
    }

    @Override
    protected CommandExecution createSecurityAnalysisCommandExecution(Path workingDir) {
        SecurityAnalysisCommandOptions options = new SecurityAnalysisCommandOptions();
        this.addParametersFile(options, workingDir, ((SecurityAnalysisExecutionInput)this.input).getParameters());
        this.mapInputToCommand(workingDir, options);
        return new CommandExecution((Command)options.toCommand(), this.executionCount);
    }

    private void addParametersFile(SecurityAnalysisCommandOptions options, Path workingDir, SecurityAnalysisParameters parameters) {
        Path parametersPath = SecurityAnalysisExecutionHandler.getParametersPath(workingDir);
        options.parametersFile(parametersPath);
        LOGGER.debug("Writing parameters to file {}", (Object)parametersPath);
        parameters.write(parametersPath);
    }
}

