/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.extensions.VoltageExtension;
import java.io.IOException;

@AutoService(value={ExtensionJsonSerializer.class})
public class VoltageExtensionSerializer
implements ExtensionJsonSerializer<LimitViolation, VoltageExtension> {
    public String getExtensionName() {
        return "Voltage";
    }

    public String getCategoryName() {
        return "security-analysis";
    }

    public Class<? super VoltageExtension> getExtensionClass() {
        return VoltageExtension.class;
    }

    public void serialize(VoltageExtension extension, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField("preContingencyValue", extension.getPreContingencyValue());
        jsonGenerator.writeEndObject();
    }

    public VoltageExtension deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        double value = Double.NaN;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.currentName().equals("preContingencyValue")) {
                parser.nextToken();
                value = ((Float)parser.readValueAs(Float.class)).floatValue();
                continue;
            }
            throw new PowsyblException("Unexpected field: " + parser.currentName());
        }
        return new VoltageExtension(value);
    }
}

