/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.limitreduction;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.limitmodification.AbstractLimitsComputerWithCache;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import com.powsybl.security.limitreduction.computation.SimpleLimitsReducer;
import java.util.Optional;

public class SimpleLimitsComputer
extends AbstractLimitsComputerWithCache<Identifiable<?>, LoadingLimits> {
    private final double limitReduction;

    public SimpleLimitsComputer(double limitReduction) {
        this.limitReduction = limitReduction;
    }

    protected Optional<LimitsContainer<LoadingLimits>> computeUncachedLimits(Identifiable<?> identifiable, LimitType limitType, ThreeSides side, boolean monitoringOnly) {
        Optional limits = LimitViolationUtils.getLoadingLimits(identifiable, (LimitType)limitType, (ThreeSides)side);
        return limits.map(limits1 -> new SimpleLimitsReducer((LoadingLimits)limits1, this.limitReduction).getLimits());
    }
}

