/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import java.util.Objects;

public abstract class AbstractDistributedSecurityAnalysisExecution {
    protected final ExternalSecurityAnalysisConfig config;
    protected final int subtaskCount;

    protected AbstractDistributedSecurityAnalysisExecution(ExternalSecurityAnalysisConfig config, int subtaskCount) {
        this.config = Objects.requireNonNull(config);
        Preconditions.checkArgument((subtaskCount > 0 ? 1 : 0) != 0, (Object)"Sub-tasks count must be positive.");
        this.subtaskCount = AbstractDistributedSecurityAnalysisExecution.checkSubtaskCount(subtaskCount);
    }

    private static int checkSubtaskCount(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Sub-tasks count must be positive.");
        return count;
    }
}

