/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.powsybl.action.Action;
import com.powsybl.action.ActionList;
import com.powsybl.computation.AbstractExecutionHandler;
import com.powsybl.computation.CommandExecution;
import com.powsybl.computation.ComputationException;
import com.powsybl.computation.ExecutionReport;
import com.powsybl.computation.Partition;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.serde.NetworkSerDe;
import com.powsybl.security.distributed.AbstractSecurityAnalysisCommandOptions;
import com.powsybl.security.execution.AbstractSecurityAnalysisExecutionInput;
import com.powsybl.security.execution.NetworkVariant;
import com.powsybl.security.json.limitreduction.LimitReductionListSerDeUtil;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.limitreduction.LimitReductionList;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import com.powsybl.security.strategy.OperatorStrategyList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityAnalysisExecutionHandler<R, T extends AbstractSecurityAnalysisExecutionInput<T>, S extends AbstractSecurityAnalysisCommandOptions<S>>
extends AbstractExecutionHandler<R> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSecurityAnalysisExecutionHandler.class);
    private static final String NETWORK_FILE = "network.xiidm";
    private static final String CONTINGENCIES_FILE = "contingencies.groovy";
    private static final String PARAMETERS_FILE = "parameters.json";
    private static final String ACTIONS_FILE = "actions.json";
    private static final String STRATEGIES_FILE = "strategies.json";
    private static final String LIMIT_REDUCTIONS_FILE = "limit-reductions.json";
    protected final int executionCount;
    protected final T input;
    private final ResultReader<R> reader;
    private final OptionsCustomizer<S> optionsCustomizer;
    private final ExceptionHandler exceptionHandler;

    protected AbstractSecurityAnalysisExecutionHandler(ResultReader<R> reader, OptionsCustomizer<S> optionsCustomizer, ExceptionHandler exceptionHandler, int executionCount, T input) {
        this.reader = Objects.requireNonNull(reader);
        this.optionsCustomizer = optionsCustomizer;
        this.exceptionHandler = exceptionHandler;
        Preconditions.checkArgument((executionCount > 0 ? 1 : 0) != 0, (Object)"Execution count must be positive.");
        this.executionCount = executionCount;
        this.input = (AbstractSecurityAnalysisExecutionInput)Objects.requireNonNull(input);
    }

    public List<CommandExecution> before(Path workingDir) throws IOException {
        CommandExecution execution = this.createSecurityAnalysisCommandExecution(workingDir);
        if (!((AbstractSecurityAnalysisExecutionInput)this.input).getMonitors().isEmpty()) {
            StateMonitor.write(((AbstractSecurityAnalysisExecutionInput)this.input).getMonitors(), workingDir.resolve("montoring_file.json"));
        }
        return Collections.singletonList(execution);
    }

    public R after(Path workingDir, ExecutionReport report) throws IOException {
        try {
            super.after(workingDir, report);
            R result = this.reader.read(workingDir);
            LOGGER.debug("End of command execution in {}. ", (Object)workingDir);
            return result;
        }
        catch (Exception exception) {
            throw this.exceptionHandler.createComputationException(workingDir, exception);
        }
    }

    protected abstract CommandExecution createSecurityAnalysisCommandExecution(Path var1);

    protected void mapInputToCommand(Path workingDir, S options) {
        ((AbstractSecurityAnalysisCommandOptions)((AbstractSecurityAnalysisCommandOptions)options).resultExtensions(((AbstractSecurityAnalysisExecutionInput)this.input).getResultExtensions())).violationTypes(((AbstractSecurityAnalysisExecutionInput)this.input).getViolationTypes());
        this.addCaseFile(options, workingDir, ((AbstractSecurityAnalysisExecutionInput)this.input).getNetworkVariant());
        ((AbstractSecurityAnalysisExecutionInput)this.input).getContingenciesSource().ifPresent(source -> this.addContingenciesFile(options, workingDir, (ByteSource)source));
        if (this.executionCount > 1) {
            ((AbstractSecurityAnalysisCommandOptions)options).task(taskNumber -> new Partition(taskNumber + 1, this.executionCount));
        }
        if (this.optionsCustomizer != null) {
            this.optionsCustomizer.customizeOptions(workingDir, options);
        }
        this.addOperatorStrategyFile(options, workingDir, ((AbstractSecurityAnalysisExecutionInput)this.input).getOperatorStrategies());
        this.addActionFile(options, workingDir, ((AbstractSecurityAnalysisExecutionInput)this.input).getActions());
        this.addLimitReductionsFile(options, workingDir, ((AbstractSecurityAnalysisExecutionInput)this.input).getLimitReductions());
    }

    private static Path getCasePath(Path workingDir) {
        return workingDir.resolve(NETWORK_FILE);
    }

    protected static Path getParametersPath(Path workingDir) {
        return workingDir.resolve(PARAMETERS_FILE);
    }

    private static Path getActionsPath(Path workingDir) {
        return workingDir.resolve(ACTIONS_FILE);
    }

    private static Path getStrategiesPath(Path workingDir) {
        return workingDir.resolve(STRATEGIES_FILE);
    }

    private static Path getLimitReductionsPath(Path workingDir) {
        return workingDir.resolve(LIMIT_REDUCTIONS_FILE);
    }

    private static Path getContingenciesPath(Path workingDir) {
        return workingDir.resolve(CONTINGENCIES_FILE);
    }

    private void addCaseFile(S options, Path workingDir, NetworkVariant variant) {
        Path dest = AbstractSecurityAnalysisExecutionHandler.getCasePath(workingDir);
        ((AbstractSecurityAnalysisCommandOptions)options).caseFile(dest);
        LOGGER.debug("Copying network to file {}", (Object)dest);
        NetworkSerDe.write((Network)variant.getVariant(), (Path)dest);
    }

    private void addContingenciesFile(S options, Path workingDir, ByteSource source) {
        Path dest = AbstractSecurityAnalysisExecutionHandler.getContingenciesPath(workingDir);
        ((AbstractSecurityAnalysisCommandOptions)options).contingenciesFile(dest);
        LOGGER.debug("Writing contingencies to file {}", (Object)dest);
        AbstractSecurityAnalysisExecutionHandler.copySourceToPath(source, dest);
    }

    private void addOperatorStrategyFile(S options, Path workingDir, List<OperatorStrategy> operatorStrategies) {
        if (operatorStrategies.isEmpty()) {
            return;
        }
        Path path = AbstractSecurityAnalysisExecutionHandler.getStrategiesPath(workingDir);
        ((AbstractSecurityAnalysisCommandOptions)options).strategiesFile(path);
        LOGGER.debug("Writing operator strategies to file {}", (Object)path);
        new OperatorStrategyList(operatorStrategies).write(path);
    }

    private void addActionFile(S options, Path workingDir, List<Action> actions) {
        if (actions.isEmpty()) {
            return;
        }
        Path path = AbstractSecurityAnalysisExecutionHandler.getActionsPath(workingDir);
        ((AbstractSecurityAnalysisCommandOptions)options).actionsFile(path);
        LOGGER.debug("Writing actions to file {}", (Object)path);
        new ActionList(actions).writeJsonFile(path);
    }

    private void addLimitReductionsFile(S options, Path workingDir, List<LimitReduction> limitReductions) {
        if (limitReductions.isEmpty()) {
            return;
        }
        Path path = AbstractSecurityAnalysisExecutionHandler.getLimitReductionsPath(workingDir);
        ((AbstractSecurityAnalysisCommandOptions)options).limitReductionsFile(path);
        LOGGER.debug("Writing limit reductions to file {}", (Object)path);
        LimitReductionListSerDeUtil.write(new LimitReductionList(limitReductions), path);
    }

    protected static void copySourceToPath(ByteSource source, Path dest) {
        try (InputStream is = source.openBufferedStream();){
            Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @FunctionalInterface
    public static interface ResultReader<R> {
        public R read(Path var1);
    }

    @FunctionalInterface
    public static interface OptionsCustomizer<S extends AbstractSecurityAnalysisCommandOptions<S>> {
        public void customizeOptions(Path var1, S var2);
    }

    @FunctionalInterface
    public static interface ExceptionHandler {
        public ComputationException createComputationException(Path var1, Exception var2);
    }
}

