/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.computation.ExecutionHandler;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.distributed.SecurityAnalysisExecutionDataHandlers;
import com.powsybl.security.distributed.SecurityAnalysisExecutionHandler;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;

public final class SecurityAnalysisExecutionHandlers {
    private static final String SA_TASK_CMD_ID = "security-analysis-task";
    private static final String SA_CMD_ID = "security-analysis";
    private static final String TASK_COUNT_ERROR_MESSAGE = "Number of subtasks must be 1 or greater, was %s.";

    private SecurityAnalysisExecutionHandlers() {
    }

    public static ExecutionHandler<SecurityAnalysisReport> forwarded(SecurityAnalysisExecutionInput input) {
        return SecurityAnalysisExecutionHandlers.forwarded(input, null);
    }

    public static ExecutionHandler<SecurityAnalysisReport> forwarded(SecurityAnalysisExecutionInput input, Integer forwardedTaskCount) {
        Preconditions.checkArgument((forwardedTaskCount == null || forwardedTaskCount >= 1 ? 1 : 0) != 0, (String)TASK_COUNT_ERROR_MESSAGE, (Object)forwardedTaskCount);
        return new SecurityAnalysisExecutionHandler<SecurityAnalysisReport>(workingDir -> SecurityAnalysisExecutionDataHandlers.readSingleResult(workingDir, input.isWithLogs(), SA_CMD_ID), (workingDir, options) -> SecurityAnalysisExecutionDataHandlers.forwardedOptions(workingDir, options, forwardedTaskCount, input.isWithLogs()), (workingDir, cause) -> SecurityAnalysisExecutionDataHandlers.generateExceptionWithLogs(workingDir, cause, SA_CMD_ID), 1, input);
    }

    public static ExecutionHandler<SecurityAnalysisReport> distributed(SecurityAnalysisExecutionInput input, int subtaskCount) {
        Preconditions.checkArgument((subtaskCount >= 1 ? 1 : 0) != 0, (String)TASK_COUNT_ERROR_MESSAGE, (int)subtaskCount);
        return new SecurityAnalysisExecutionHandler<SecurityAnalysisReport>(workingDir -> SecurityAnalysisExecutionDataHandlers.readResults(workingDir, subtaskCount, input.isWithLogs(), SA_TASK_CMD_ID), (workingDir, options) -> SecurityAnalysisExecutionDataHandlers.distributedOptions(workingDir, options, subtaskCount, input.isWithLogs(), SA_TASK_CMD_ID), (workingDir, cause) -> SecurityAnalysisExecutionDataHandlers.generateExceptionWithLogs(workingDir, cause, subtaskCount, SA_TASK_CMD_ID), subtaskCount, input);
    }
}

