/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.condition.AllViolationCondition;
import com.powsybl.security.condition.AnyViolationCondition;
import com.powsybl.security.condition.AtLeastOneViolationCondition;
import com.powsybl.security.condition.Condition;
import com.powsybl.security.condition.TrueCondition;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ConditionDeserializer
extends StdDeserializer<Condition> {
    public ConditionDeserializer() {
        super(Condition.class);
    }

    public Condition deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parseObject((JsonParser)parser, fieldName -> {
            switch (fieldName) {
                case "type": {
                    context.type = parser.nextTextValue();
                    return true;
                }
                case "violationIds": {
                    parser.nextToken();
                    context.violationIds = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, String.class);
                    return true;
                }
                case "filters": {
                    parser.nextToken();
                    context.conditionFilters = JsonUtil.readSet((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolationType.class);
                    return true;
                }
            }
            return false;
        });
        switch (context.type) {
            case "TRUE_CONDITION": {
                return new TrueCondition();
            }
            case "ANY_VIOLATION_CONDITION": {
                return new AnyViolationCondition(context.conditionFilters);
            }
            case "AT_LEAST_ONE_VIOLATION": {
                return new AtLeastOneViolationCondition(context.violationIds, context.conditionFilters);
            }
            case "ALL_VIOLATION": {
                return new AllViolationCondition(context.violationIds, context.conditionFilters);
            }
        }
        throw new JsonMappingException((Closeable)parser, "Unexpected condition type: " + context.type);
    }

    private static class ParsingContext {
        String type;
        List<String> violationIds;
        Set<LimitViolationType> conditionFilters = Collections.emptySet();

        private ParsingContext() {
        }
    }
}

