/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.Contingency;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.json.AbstractContingencyResultDeserializer;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.PostContingencyResult;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;

public class PostContingencyResultDeserializer
extends AbstractContingencyResultDeserializer<PostContingencyResult> {
    protected static final String CONTEXT_NAME = "PostContingencyResult";

    public PostContingencyResultDeserializer() {
        super(PostContingencyResult.class);
    }

    public PostContingencyResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String version = JsonUtil.getSourceVersion((DatabindContext)deserializationContext, (String)"sourceVersionAttribute");
        if (version == null) {
            version = "1.7";
        }
        String finalVersion = version;
        ParsingContext parsingContext = new ParsingContext();
        AbstractContingencyResultDeserializer.ParsingContext commonParsingContext = new AbstractContingencyResultDeserializer.ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            boolean found = this.deserializeCommonAttributes(parser, commonParsingContext, name, deserializationContext, finalVersion, CONTEXT_NAME);
            if (found) {
                return true;
            }
            switch (parser.currentName()) {
                case "contingency": {
                    parser.nextToken();
                    parsingContext.contingency = (Contingency)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, Contingency.class);
                    return true;
                }
                case "status": {
                    parser.nextToken();
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: status", (String)finalVersion, (String)"1.3");
                    parsingContext.status = (PostContingencyComputationStatus)((Object)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, PostContingencyComputationStatus.class)));
                    return true;
                }
                case "connectivityResult": {
                    parser.nextToken();
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: connectivityResult", (String)finalVersion, (String)"1.4");
                    parsingContext.connectivityResult = (ConnectivityResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ConnectivityResult.class);
                    return true;
                }
            }
            return false;
        });
        if (parsingContext.connectivityResult == null) {
            parsingContext.connectivityResult = new ConnectivityResult(0, 0, 0.0, 0.0, Collections.emptySet());
        }
        if (version.compareTo("1.3") < 0) {
            Objects.requireNonNull(commonParsingContext.limitViolationsResult);
            PostContingencyComputationStatus postContingencyComputationStatus = parsingContext.status = commonParsingContext.limitViolationsResult.isComputationOk() ? PostContingencyComputationStatus.CONVERGED : PostContingencyComputationStatus.FAILED;
        }
        if (commonParsingContext.networkResult != null) {
            return new PostContingencyResult(parsingContext.contingency, parsingContext.status, commonParsingContext.limitViolationsResult, commonParsingContext.networkResult, parsingContext.connectivityResult);
        }
        return new PostContingencyResult(parsingContext.contingency, parsingContext.status, commonParsingContext.limitViolationsResult, commonParsingContext.branchResults, commonParsingContext.busResults, commonParsingContext.threeWindingsTransformerResults, parsingContext.connectivityResult);
    }

    private static class ParsingContext {
        Contingency contingency = null;
        PostContingencyComputationStatus status = null;
        ConnectivityResult connectivityResult = null;

        private ParsingContext() {
        }
    }
}

