/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.results;

import com.google.common.collect.ImmutableMap;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class NetworkResult {
    private final Map<String, BranchResult> branchResults;
    private final Map<String, BusResult> busResults;
    private final Map<String, ThreeWindingsTransformerResult> threeWindingsTransformerResults;

    public NetworkResult(Collection<BranchResult> branchResults, Collection<BusResult> busResults, Collection<ThreeWindingsTransformerResult> threeWindingsTransformerResults) {
        this.branchResults = (Map)Objects.requireNonNull(branchResults).stream().collect(ImmutableMap.toImmutableMap(BranchResult::getBranchId, Function.identity()));
        this.busResults = (Map)Objects.requireNonNull(busResults).stream().collect(ImmutableMap.toImmutableMap(BusResult::getBusId, Function.identity()));
        this.threeWindingsTransformerResults = (Map)Objects.requireNonNull(threeWindingsTransformerResults).stream().collect(ImmutableMap.toImmutableMap(ThreeWindingsTransformerResult::getThreeWindingsTransformerId, Function.identity()));
    }

    public List<BranchResult> getBranchResults() {
        return List.copyOf(this.branchResults.values());
    }

    public BranchResult getBranchResult(String branchId) {
        return this.branchResults.get(branchId);
    }

    public List<BusResult> getBusResults() {
        return List.copyOf(this.busResults.values());
    }

    public BusResult getBusResult(String busId) {
        return this.busResults.get(busId);
    }

    public List<ThreeWindingsTransformerResult> getThreeWindingsTransformerResults() {
        return List.copyOf(this.threeWindingsTransformerResults.values());
    }

    public ThreeWindingsTransformerResult getThreeWindingsTransformerResult(String threeWindingsTransformerId) {
        return this.threeWindingsTransformerResults.get(threeWindingsTransformerId);
    }
}

