/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Network;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisProvider;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFactorModelReader;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityResultModelWriter;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class SensitivityAnalysis {
    private SensitivityAnalysis() {
        throw new IllegalStateException("Utility class should not been instantiated");
    }

    public static Runner find(String name) {
        return new Runner((SensitivityAnalysisProvider)PlatformConfigNamedProvider.Finder.find((String)name, (String)"sensitivity-analysis", SensitivityAnalysisProvider.class, (PlatformConfig)PlatformConfig.defaultConfig()));
    }

    public static Runner find() {
        return SensitivityAnalysis.find(null);
    }

    public static CompletableFuture<Void> runAsync(Network network, String workingVariantId, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
        return SensitivityAnalysis.find().runAsync(network, workingVariantId, factorReader, resultWriter, contingencies, variableSets, parameters, computationManager, reporter);
    }

    public static CompletableFuture<SensitivityAnalysisResult> runAsync(Network network, String workingVariantId, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
        return SensitivityAnalysis.find().runAsync(network, workingVariantId, factors, contingencies, variableSets, parameters, computationManager, reporter);
    }

    public static void run(Network network, String workingVariantId, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
        SensitivityAnalysis.find().run(network, workingVariantId, factorReader, resultWriter, contingencies, variableSets, parameters, computationManager, reporter);
    }

    public static SensitivityAnalysisResult run(Network network, String workingVariantId, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
        return SensitivityAnalysis.find().run(network, workingVariantId, factors, contingencies, variableSets, parameters, computationManager, reporter);
    }

    public static SensitivityAnalysisResult run(Network network, String workingVariantId, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters) {
        return SensitivityAnalysis.find().run(network, workingVariantId, factors, contingencies, variableSets, parameters);
    }

    public static SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters) {
        return SensitivityAnalysis.find().run(network, factors, contingencies, variableSets, parameters);
    }

    public static SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, List<Contingency> contingencies, SensitivityAnalysisParameters parameters) {
        return SensitivityAnalysis.find().run(network, factors, contingencies, parameters);
    }

    public static SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, List<Contingency> contingencies) {
        return SensitivityAnalysis.find().run(network, factors, contingencies);
    }

    public static SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors) {
        return SensitivityAnalysis.find().run(network, factors);
    }

    public static SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, SensitivityAnalysisParameters parameters) {
        return SensitivityAnalysis.find().run(network, factors, parameters);
    }

    public static final class Runner
    implements Versionable {
        private final SensitivityAnalysisProvider provider;

        public Runner(SensitivityAnalysisProvider provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        public CompletableFuture<Void> runAsync(Network network, String workingVariantId, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
            Objects.requireNonNull(network, "Network should not be null");
            Objects.requireNonNull(workingVariantId, "Working variant ID should not be null");
            Objects.requireNonNull(factorReader, "Sensitivity factors reader should not be null");
            Objects.requireNonNull(resultWriter, "Sensitivity results writer should not be null");
            Objects.requireNonNull(contingencies, "Contingency list should not be null");
            Objects.requireNonNull(variableSets, "VariableSet list should not be null");
            Objects.requireNonNull(parameters, "Sensitivity analysis parameters should not be null");
            Objects.requireNonNull(computationManager, "Computation manager should not be null");
            Objects.requireNonNull(reporter, "Reporter should not be null");
            return this.provider.run(network, workingVariantId, factorReader, resultWriter, contingencies, variableSets, parameters, computationManager, reporter);
        }

        public CompletableFuture<SensitivityAnalysisResult> runAsync(Network network, String workingVariantId, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
            Objects.requireNonNull(network, "Network should not be null");
            Objects.requireNonNull(workingVariantId, "Working variant ID should not be null");
            Objects.requireNonNull(factors, "Sensitivity factor list should not be null");
            Objects.requireNonNull(contingencies, "Contingency list should not be null");
            Objects.requireNonNull(variableSets, "VariableSet list should not be null");
            Objects.requireNonNull(parameters, "Sensitivity analysis parameters should not be null");
            Objects.requireNonNull(computationManager, "Computation manager should not be null");
            Objects.requireNonNull(reporter, "Reporter should not be null");
            SensitivityFactorModelReader factorReader = new SensitivityFactorModelReader(factors, network);
            SensitivityResultModelWriter resultWriter = new SensitivityResultModelWriter(contingencies);
            return this.provider.run(network, workingVariantId, factorReader, resultWriter, contingencies, variableSets, parameters, computationManager, reporter).thenApply(unused -> new SensitivityAnalysisResult(factors, resultWriter.getContingencyStatuses(), resultWriter.getValues()));
        }

        public void run(Network network, String workingVariantId, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
            this.runAsync(network, workingVariantId, factorReader, resultWriter, contingencies, variableSets, parameters, computationManager, reporter).join();
        }

        public SensitivityAnalysisResult run(Network network, String workingVariantId, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters, ComputationManager computationManager, Reporter reporter) {
            return this.runAsync(network, workingVariantId, factors, contingencies, variableSets, parameters, computationManager, reporter).join();
        }

        public SensitivityAnalysisResult run(Network network, String workingVariantId, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters) {
            return this.runAsync(network, workingVariantId, factors, contingencies, variableSets, parameters, LocalComputationManager.getDefault(), Reporter.NO_OP).join();
        }

        public SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters parameters) {
            return this.run(network, "InitialState", factors, contingencies, variableSets, parameters);
        }

        public SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, List<Contingency> contingencies, SensitivityAnalysisParameters parameters) {
            return this.run(network, "InitialState", factors, contingencies, Collections.emptyList(), parameters);
        }

        public SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, List<Contingency> contingencies) {
            return this.run(network, factors, contingencies, Collections.emptyList(), SensitivityAnalysisParameters.load());
        }

        public SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors) {
            return this.run(network, factors, Collections.emptyList());
        }

        public SensitivityAnalysisResult run(Network network, List<SensitivityFactor> factors, SensitivityAnalysisParameters parameters) {
            return this.run(network, factors, Collections.emptyList(), parameters);
        }

        public String getName() {
            return this.provider.getName();
        }

        public String getVersion() {
            return this.provider.getVersion();
        }
    }
}

