/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.PowsyblException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class SensitivityValue {
    private final int factorIndex;
    private final int contingencyIndex;
    private final double value;
    private final double functionReference;

    public SensitivityValue(int factorIndex, int contingencyIndex, double value, double functionReference) {
        this.factorIndex = factorIndex;
        if (contingencyIndex < -1) {
            throw new IllegalArgumentException("Invalid contingency index: " + contingencyIndex);
        }
        this.contingencyIndex = contingencyIndex;
        this.value = value;
        this.functionReference = functionReference;
    }

    public int getFactorIndex() {
        return this.factorIndex;
    }

    public int getContingencyIndex() {
        return this.contingencyIndex;
    }

    public double getValue() {
        return this.value;
    }

    public double getFunctionReference() {
        return this.functionReference;
    }

    public String toString() {
        return "SensitivityValue(factorIndex=" + this.factorIndex + ", contingencyIndex='" + this.contingencyIndex + "', value=" + this.value + ", functionReference=" + this.functionReference + ")";
    }

    public static SensitivityValue parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        ParsingContext context = new ParsingContext();
        try {
            JsonToken token;
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    SensitivityValue.parseJson(parser, context);
                    continue;
                }
                if (token != JsonToken.END_OBJECT) continue;
                return new SensitivityValue(context.factorIndex, context.contingencyIndex, context.value, context.functionReference);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new PowsyblException("Parsing error");
    }

    private static void parseJson(JsonParser parser, ParsingContext context) throws IOException {
        String fieldName;
        switch (fieldName = parser.getCurrentName()) {
            case "factorIndex": {
                parser.nextToken();
                context.factorIndex = parser.getIntValue();
                break;
            }
            case "contingencyIndex": {
                parser.nextToken();
                context.contingencyIndex = parser.getIntValue();
                break;
            }
            case "value": {
                parser.nextToken();
                context.value = parser.getDoubleValue();
                break;
            }
            case "functionReference": {
                parser.nextToken();
                context.functionReference = parser.getDoubleValue();
                break;
            }
            default: {
                throw new PowsyblException("Unexpected field: " + fieldName);
            }
        }
    }

    public static void writeJson(JsonGenerator generator, SensitivityValue value) {
        SensitivityValue.writeJson(generator, value.factorIndex, value.contingencyIndex, value.value, value.functionReference);
    }

    static void writeJson(JsonGenerator jsonGenerator, int factorIndex, int contingencyIndex, double value, double functionReference) {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("factorIndex", factorIndex);
            if (contingencyIndex != -1) {
                jsonGenerator.writeNumberField("contingencyIndex", contingencyIndex);
            }
            jsonGenerator.writeNumberField("value", value);
            jsonGenerator.writeNumberField("functionReference", functionReference);
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static final class ParsingContext {
        private int factorIndex;
        private int contingencyIndex = -1;
        private double value;
        private double functionReference;

        ParsingContext() {
        }
    }
}

