/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WeightedSensitivityVariable {
    private final String id;
    private final double weight;

    public WeightedSensitivityVariable(String id, double weight) {
        this.id = Objects.requireNonNull(id);
        if (Double.isNaN(weight)) {
            throw new IllegalArgumentException("Invalid weigth: " + weight);
        }
        this.weight = weight;
    }

    public String getId() {
        return this.id;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        return "WeightedSensitivityVariable(id='" + this.id + "', weight=" + this.weight + ")";
    }

    public static List<WeightedSensitivityVariable> parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        ArrayList<WeightedSensitivityVariable> variables = new ArrayList<WeightedSensitivityVariable>();
        try {
            JsonToken token;
            ParsingContext context = new ParsingContext();
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName;
                    switch (fieldName = parser.getCurrentName()) {
                        case "id": {
                            context.id = parser.nextTextValue();
                            break;
                        }
                        case "weight": {
                            parser.nextToken();
                            context.weight = parser.getDoubleValue();
                            break;
                        }
                    }
                    continue;
                }
                if (token != JsonToken.END_ARRAY) {
                    if (token != JsonToken.END_OBJECT) continue;
                    variables.add(new WeightedSensitivityVariable(context.id, context.weight));
                    context.reset();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return variables;
    }

    private static final class ParsingContext {
        private String id;
        private double weight = Double.NaN;

        private ParsingContext() {
        }

        private void reset() {
            this.id = null;
            this.weight = Double.NaN;
        }
    }
}

