/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFunctionType;
import com.powsybl.sensitivity.SensitivityValue;
import com.powsybl.sensitivity.SensitivityValueKey;
import com.powsybl.sensitivity.SensitivityVariableType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.alg.util.Triple;

public class SensitivityAnalysisResult {
    private final List<SensitivityFactor> factors;
    private final List<SensitivityContingencyStatus> contingencyStatuses;
    private final List<SensitivityValue> values;
    private final Map<String, List<SensitivityValue>> valuesByContingencyId = new HashMap<String, List<SensitivityValue>>();
    private final Map<SensitivityValueKey, SensitivityValue> valuesByContingencyIdAndFunctionAndVariable = new HashMap<SensitivityValueKey, SensitivityValue>();
    private final Map<Triple<SensitivityFunctionType, String, String>, Double> functionReferenceByContingencyAndFunction = new HashMap<Triple<SensitivityFunctionType, String, String>, Double>();
    private final Map<String, SensitivityContingencyStatus> statusByContingencyId = new HashMap<String, SensitivityContingencyStatus>();

    public SensitivityAnalysisResult(List<SensitivityFactor> factors, List<SensitivityContingencyStatus> contingencyStatuses, List<SensitivityValue> values) {
        this.factors = Collections.unmodifiableList(Objects.requireNonNull(factors));
        this.contingencyStatuses = Collections.unmodifiableList(Objects.requireNonNull(contingencyStatuses));
        this.values = Collections.unmodifiableList(Objects.requireNonNull(values));
        for (SensitivityValue value : values) {
            SensitivityFactor factor = factors.get(value.getFactorIndex());
            String contingencyId = value.getContingencyIndex() != -1 ? contingencyStatuses.get(value.getContingencyIndex()).getContingencyId() : null;
            this.valuesByContingencyId.computeIfAbsent(contingencyId, k -> new ArrayList()).add(value);
            this.valuesByContingencyIdAndFunctionAndVariable.put(new SensitivityValueKey(contingencyId, factor.getVariableId(), factor.getFunctionId(), factor.getFunctionType(), factor.getVariableType()), value);
            this.functionReferenceByContingencyAndFunction.put((Triple<SensitivityFunctionType, String, String>)Triple.of((Object)((Object)factor.getFunctionType()), (Object)contingencyId, (Object)factor.getFunctionId()), value.getFunctionReference());
        }
        for (SensitivityContingencyStatus status : contingencyStatuses) {
            this.statusByContingencyId.put(status.getContingencyId(), status);
        }
    }

    public List<SensitivityFactor> getFactors() {
        return this.factors;
    }

    public List<SensitivityContingencyStatus> getContingencyStatuses() {
        return this.contingencyStatuses;
    }

    public List<SensitivityValue> getValues() {
        return this.values;
    }

    public List<SensitivityValue> getValues(String contingencyId) {
        return this.valuesByContingencyId.getOrDefault(contingencyId, Collections.emptyList());
    }

    public List<SensitivityValue> getPreContingencyValues() {
        return this.valuesByContingencyId.getOrDefault(null, Collections.emptyList());
    }

    public double getSensitivityValue(String contingencyId, String variableId, String functionId, SensitivityFunctionType functionType, SensitivityVariableType variableType) {
        SensitivityValue value = this.valuesByContingencyIdAndFunctionAndVariable.get(new SensitivityValueKey(contingencyId, variableId, functionId, functionType, variableType));
        if (value != null) {
            return value.getValue();
        }
        throw new PowsyblException("Sensitivity value not found for contingency '" + contingencyId + "', function '" + functionId + "', variable '" + variableId + "'', functionType '" + functionType);
    }

    public double getBranchFlow1SensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_1, variableType);
    }

    public double getBranchFlow2SensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_2, variableType);
    }

    public double getBranchFlow3SensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3, variableType);
    }

    public double getBranchCurrent1SensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BRANCH_CURRENT_1, variableType);
    }

    public double getBranchCurrent2SensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BRANCH_CURRENT_2, variableType);
    }

    public double getBranchCurrent3SensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BRANCH_CURRENT_3, variableType);
    }

    public double getBusVoltageSensitivityValue(String contingencyId, String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(contingencyId, variableId, functionId, SensitivityFunctionType.BUS_VOLTAGE, variableType);
    }

    public double getSensitivityValue(String variableId, String functionId, SensitivityFunctionType functionType, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, functionType, variableType);
    }

    public double getBranchFlow1SensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_1, variableType);
    }

    public double getBranchFlow2SensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_2, variableType);
    }

    public double getBranchFlow3SensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3, variableType);
    }

    public double getBranchCurrent1SensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BRANCH_CURRENT_1, variableType);
    }

    public double getBranchCurrent2SensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BRANCH_CURRENT_2, variableType);
    }

    public double getBranchCurrent3SensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BRANCH_CURRENT_3, variableType);
    }

    public double getBusVoltageSensitivityValue(String variableId, String functionId, SensitivityVariableType variableType) {
        return this.getSensitivityValue(null, variableId, functionId, SensitivityFunctionType.BUS_VOLTAGE, variableType);
    }

    public double getFunctionReferenceValue(String contingencyId, String functionId, SensitivityFunctionType functionType) {
        Double value = this.functionReferenceByContingencyAndFunction.get(Triple.of((Object)((Object)functionType), (Object)contingencyId, (Object)functionId));
        if (value == null) {
            throw new PowsyblException("Reference flow value not found for contingency '" + contingencyId + "', function '" + functionId + "'', functionType '" + functionType);
        }
        return value;
    }

    public double getBranchFlow1FunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_1);
    }

    public double getBranchFlow2FunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_2);
    }

    public double getBranchFlow3FunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3);
    }

    public double getBranchCurrent1FunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BRANCH_CURRENT_1);
    }

    public double getBranchCurrent2FunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BRANCH_CURRENT_2);
    }

    public double getBranchCurrent3FunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BRANCH_CURRENT_3);
    }

    public double getBusVoltageFunctionReferenceValue(String contingencyId, String functionId) {
        return this.getFunctionReferenceValue(contingencyId, functionId, SensitivityFunctionType.BUS_VOLTAGE);
    }

    public double getFunctionReferenceValue(String functionId, SensitivityFunctionType functionType) {
        return this.getFunctionReferenceValue(null, functionId, functionType);
    }

    public double getBranchFlow1FunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_1);
    }

    public double getBranchFlow2FunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_2);
    }

    public double getBranchFlow3FunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3);
    }

    public double getBranchCurrent1FunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BRANCH_CURRENT_1);
    }

    public double getBranchCurrent2FunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BRANCH_CURRENT_2);
    }

    public double getBranchCurrent3FunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BRANCH_CURRENT_3);
    }

    public double getBusVoltageFunctionReferenceValue(String functionId) {
        return this.getFunctionReferenceValue(null, functionId, SensitivityFunctionType.BUS_VOLTAGE);
    }

    public Status getContingencyStatus(String contingencyId) {
        return this.statusByContingencyId.get(contingencyId).getStatus();
    }

    public static class SensitivityContingencyStatus {
        private final String contingencyId;
        private final Status status;

        public String getContingencyId() {
            return this.contingencyId;
        }

        public Status getStatus() {
            return this.status;
        }

        public SensitivityContingencyStatus(String contingencyId, Status status) {
            this.contingencyId = Objects.requireNonNull(contingencyId);
            this.status = Objects.requireNonNull(status);
        }

        public static void writeJson(JsonGenerator jsonGenerator, SensitivityContingencyStatus contingencyStatus) {
            try {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("contingencyId", contingencyStatus.getContingencyId());
                jsonGenerator.writeStringField("contingencyStatus", contingencyStatus.status.name());
                jsonGenerator.writeEndObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public static SensitivityContingencyStatus parseJson(JsonParser parser) {
            Objects.requireNonNull(parser);
            ParsingContext context = new ParsingContext();
            try {
                JsonToken token;
                while ((token = parser.nextToken()) != null) {
                    if (token == JsonToken.FIELD_NAME) {
                        SensitivityContingencyStatus.parseJson(parser, context);
                        continue;
                    }
                    if (token != JsonToken.END_OBJECT) continue;
                    return new SensitivityContingencyStatus(context.contingency != null ? context.contingency.getId() : "", context.status);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            throw new PowsyblException("Parsing error");
        }

        private static void parseJson(JsonParser parser, ParsingContext context) throws IOException {
            String fieldName;
            switch (fieldName = parser.getCurrentName()) {
                case "contingencyId": {
                    parser.nextToken();
                    context.contingency = new Contingency(parser.getValueAsString(), new ContingencyElement[0]);
                    break;
                }
                case "contingencyStatus": {
                    parser.nextToken();
                    context.status = Status.valueOf(parser.getValueAsString());
                    break;
                }
                default: {
                    throw new PowsyblException("Unexpected field: " + fieldName);
                }
            }
        }

        static final class ParsingContext {
            private Contingency contingency;
            private Status status;

            ParsingContext() {
            }
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        NO_IMPACT;

    }
}

