/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.CsvTableFormatterFactory;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.contingency.Contingency;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityResultWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;

public class SensitivityResultCsvWriter
implements SensitivityResultWriter {
    private final TableFormatter formatter;
    private final TableFormatter formatterContingencyStatus;
    private final List<Contingency> contingencies;

    public SensitivityResultCsvWriter(TableFormatter formatter, TableFormatter formatterContingencyStatus, List<Contingency> contingencies) {
        this.formatter = Objects.requireNonNull(formatter);
        this.formatterContingencyStatus = Objects.requireNonNull(formatterContingencyStatus);
        this.contingencies = Objects.requireNonNull(contingencies);
    }

    public static TableFormatter createTableFormatter(Writer writer) {
        Objects.requireNonNull(writer);
        CsvTableFormatterFactory factory = new CsvTableFormatterFactory();
        TableFormatterConfig tfc = TableFormatterConfig.load();
        return factory.create(writer, "Sensitivity analysis result", tfc, new Column[]{new Column("Contingency ID"), new Column("Factor index"), new Column("Function ref value"), new Column("Sensitivity value")});
    }

    public static TableFormatter createContingencyStatusTableFormatter(Writer writer) {
        Objects.requireNonNull(writer);
        CsvTableFormatterFactory factory = new CsvTableFormatterFactory();
        TableFormatterConfig tfc = TableFormatterConfig.load();
        return factory.create(writer, "Sensitivity analysis contingency status result", tfc, new Column[]{new Column("Contingency ID"), new Column("Contingency Status")});
    }

    @Override
    public void writeSensitivityValue(int factorIndex, int contingencyIndex, double value, double functionReference) {
        Contingency contingency = contingencyIndex != -1 ? this.contingencies.get(contingencyIndex) : null;
        try {
            this.formatter.writeCell(contingency != null ? contingency.getId() : "");
            this.formatter.writeCell(factorIndex);
            this.formatter.writeCell(functionReference);
            this.formatter.writeCell(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeContingencyStatus(int contingencyIndex, SensitivityAnalysisResult.Status status) {
        try {
            this.formatterContingencyStatus.writeCell(this.contingencies.get(contingencyIndex).getId());
            this.formatterContingencyStatus.writeCell(status.name());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

