/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.contingency.Contingency;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityValue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SensitivityResultJsonWriter
implements SensitivityResultWriter,
AutoCloseable {
    private final JsonGenerator jsonGenerator;
    private final List<Contingency> contingencies;
    private final List<SensitivityAnalysisResult.SensitivityContingencyStatus> contingencyStatusBuffer;

    public SensitivityResultJsonWriter(JsonGenerator jsonGenerator, List<Contingency> contingencies) {
        this.jsonGenerator = Objects.requireNonNull(jsonGenerator);
        this.contingencies = Objects.requireNonNull(contingencies);
        this.contingencyStatusBuffer = new ArrayList<Object>(Collections.nCopies(contingencies.size(), null));
        try {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeStartArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeSensitivityValue(int factorIndex, int contingencyIndex, double value, double functionReference) {
        SensitivityValue.writeJson(this.jsonGenerator, factorIndex, contingencyIndex, value, functionReference);
    }

    @Override
    public void writeContingencyStatus(int contingencyIndex, SensitivityAnalysisResult.Status status) {
        this.contingencyStatusBuffer.set(contingencyIndex, new SensitivityAnalysisResult.SensitivityContingencyStatus(this.contingencies.get(contingencyIndex).getId(), status));
    }

    @Override
    public void close() {
        try {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeStartArray();
            for (SensitivityAnalysisResult.SensitivityContingencyStatus status : this.contingencyStatusBuffer) {
                SensitivityAnalysisResult.SensitivityContingencyStatus.writeJson(this.jsonGenerator, status);
            }
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

