/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.powsybl.contingency.Contingency;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SensitivityResultModelWriter
implements SensitivityResultWriter {
    private final List<Contingency> contingencies;
    private final List<SensitivityValue> values = new ArrayList<SensitivityValue>();
    private final List<SensitivityAnalysisResult.SensitivityContingencyStatus> contingencyStatuses;

    public SensitivityResultModelWriter(List<Contingency> contingencies) {
        this.contingencies = Objects.requireNonNull(contingencies);
        this.contingencyStatuses = new ArrayList<Object>(Collections.nCopies(contingencies.size(), null));
    }

    public List<SensitivityValue> getValues() {
        return this.values;
    }

    public List<SensitivityAnalysisResult.SensitivityContingencyStatus> getContingencyStatuses() {
        return this.contingencyStatuses;
    }

    @Override
    public void writeSensitivityValue(int factorIndex, int contingencyIndex, double value, double functionReference) {
        this.values.add(new SensitivityValue(factorIndex, contingencyIndex, value, functionReference));
    }

    @Override
    public void writeContingencyStatus(int contingencyIndex, SensitivityAnalysisResult.Status status) {
        this.contingencyStatuses.set(contingencyIndex, new SensitivityAnalysisResult.SensitivityContingencyStatus(this.contingencies.get(contingencyIndex).getId(), status));
    }
}

