/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.PowsyblException;
import com.powsybl.sensitivity.WeightedSensitivityVariable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SensitivityVariableSet {
    private final String id;
    private final Map<String, WeightedSensitivityVariable> variables;

    public SensitivityVariableSet(String id, List<WeightedSensitivityVariable> variables) {
        this.id = Objects.requireNonNull(id);
        this.variables = Collections.unmodifiableMap(Objects.requireNonNull(variables).stream().collect(LinkedHashMap::new, (map, item) -> map.put(item.getId(), item), Map::putAll));
    }

    public String getId() {
        return this.id;
    }

    public Collection<WeightedSensitivityVariable> getVariables() {
        return this.variables.values();
    }

    public Map<String, WeightedSensitivityVariable> getVariablesById() {
        return this.variables;
    }

    public WeightedSensitivityVariable getVariable(String key) {
        return this.variables.get(key);
    }

    public String toString() {
        return "SensitivityVariableSet(id='" + this.id + "', variables=" + this.variables + ")";
    }

    public static void writeJson(JsonGenerator jsonGenerator, SensitivityVariableSet variableSet) {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("id", variableSet.getId());
            jsonGenerator.writeFieldName("variables");
            jsonGenerator.writeStartArray();
            for (WeightedSensitivityVariable variable : variableSet.getVariables()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("id", variable.getId());
                jsonGenerator.writeNumberField("weight", variable.getWeight());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SensitivityVariableSet parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        try {
            JsonToken token;
            String id = null;
            List<WeightedSensitivityVariable> variables = null;
            block10: while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName;
                    switch (fieldName = parser.getCurrentName()) {
                        case "id": {
                            id = parser.nextTextValue();
                            continue block10;
                        }
                        case "variables": {
                            variables = WeightedSensitivityVariable.parseJson(parser);
                            continue block10;
                        }
                    }
                    throw new PowsyblException("Unexpected field: " + fieldName);
                }
                if (token != JsonToken.END_OBJECT) continue;
                return new SensitivityVariableSet(id, variables);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new PowsyblException("Parsing error");
    }
}

