/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import com.google.common.base.Stopwatch;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.DefaultComputationManagerConfig;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.contingency.json.ContingencyJsonModule;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.sensitivity.SensitivityAnalysis;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFactorJsonReader;
import com.powsybl.sensitivity.SensitivityResultCsvWriter;
import com.powsybl.sensitivity.SensitivityResultJsonWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import com.powsybl.sensitivity.json.JsonSensitivityAnalysisParameters;
import com.powsybl.sensitivity.json.SensitivityJsonModule;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolRunningContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@AutoService(value={Tool.class})
public class SensitivityAnalysisTool
implements Tool {
    private static final String CASE_FILE_OPTION = "case-file";
    private static final String OUTPUT_FILE_OPTION = "output-file";
    private static final String FACTORS_FILE_OPTION = "factors-file";
    private static final String CONTINGENCIES_FILE_OPTION = "contingencies-file";
    private static final String VARIABLE_SETS_FILE_OPTION = "variable-sets-file";
    private static final String PARAMETERS_FILE = "parameters-file";
    private static final String OUTPUT_CONTINGENCY_STATUS_FILE_OPTION = "output-contingency-file";
    private static final String SINGLE_OUTPUT = "single-output";

    public Command getCommand() {
        return new Command(){

            public String getName() {
                return "sensitivity-analysis";
            }

            public String getTheme() {
                return "Computation";
            }

            public String getDescription() {
                return "Run sensitivity analysis";
            }

            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.CASE_FILE_OPTION).desc("the case path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.FACTORS_FILE_OPTION).desc("sensitivity factors input file path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.CONTINGENCIES_FILE_OPTION).desc("contingencies input file path").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.VARIABLE_SETS_FILE_OPTION).desc("variable sets input file path").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.OUTPUT_FILE_OPTION).desc("Sensitivity results output path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.OUTPUT_CONTINGENCY_STATUS_FILE_OPTION).desc("contingency status output path (csv only)").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.SINGLE_OUTPUT).desc("Output sensitivity analysis results in a single json file using output file option (values, factors and contingency status).").build());
                options.addOption(Option.builder().longOpt(SensitivityAnalysisTool.PARAMETERS_FILE).desc("sensitivity analysis parameters as JSON file").hasArg().argName("FILE").build());
                options.addOption(ConversionToolUtils.createImportParametersFileOption());
                options.addOption(ConversionToolUtils.createImportParameterOption());
                return options;
            }

            public String getUsageFooter() {
                return null;
            }
        };
    }

    private static boolean isCsv(Path outputFile) {
        String fileName = outputFile.getFileName().toString();
        if (fileName.endsWith(".json")) {
            return false;
        }
        if (fileName.endsWith(".csv")) {
            return true;
        }
        throw new PowsyblException("Unsupported output format: " + fileName);
    }

    private static String buildContingencyStatusPath(String outputFile) {
        return outputFile.replace(".csv", "_contingency_status.csv");
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        Stopwatch stopwatch;
        block66: {
            List variableSets;
            List contingencies;
            Path outputFileStatus;
            Path caseFile = context.getFileSystem().getPath(line.getOptionValue(CASE_FILE_OPTION), new String[0]);
            Path outputFile = context.getFileSystem().getPath(line.getOptionValue(OUTPUT_FILE_OPTION), new String[0]);
            boolean csv = SensitivityAnalysisTool.isCsv(outputFile);
            if (csv) {
                outputFileStatus = line.hasOption(OUTPUT_CONTINGENCY_STATUS_FILE_OPTION) ? context.getFileSystem().getPath(line.getOptionValue(OUTPUT_CONTINGENCY_STATUS_FILE_OPTION), new String[0]) : context.getFileSystem().getPath(SensitivityAnalysisTool.buildContingencyStatusPath(line.getOptionValue(OUTPUT_FILE_OPTION)), new String[0]);
                boolean contingencyCsv = SensitivityAnalysisTool.isCsv(outputFileStatus);
                if (!contingencyCsv) {
                    throw new PowsyblException("output-file and output-contingency-file files must have the same format (csv).");
                }
                if (line.hasOption(SINGLE_OUTPUT)) {
                    throw new PowsyblException("Unsupported single-output option does not support csv file as argument of output-file. Must be json.");
                }
            } else {
                outputFileStatus = null;
            }
            Path factorsFile = context.getFileSystem().getPath(line.getOptionValue(FACTORS_FILE_OPTION), new String[0]);
            context.getOutputStream().println("Loading network '" + caseFile + "'");
            Properties inputParams = ConversionToolUtils.readProperties((CommandLine)line, (ConversionToolUtils.OptionType)ConversionToolUtils.OptionType.IMPORT, (ToolRunningContext)context);
            Network network = Network.read((Path)caseFile, (ComputationManager)context.getShortTimeExecutionComputationManager(), (ImportConfig)ImportConfig.load(), (Properties)inputParams);
            if (network == null) {
                throw new PowsyblException("Case '" + caseFile + "' not found");
            }
            ObjectMapper objectMapper = JsonSensitivityAnalysisParameters.createObjectMapper().registerModule((Module)new ContingencyJsonModule());
            SensitivityAnalysisParameters params = SensitivityAnalysisParameters.load();
            if (line.hasOption(PARAMETERS_FILE)) {
                Path parametersFile = context.getFileSystem().getPath(line.getOptionValue(PARAMETERS_FILE), new String[0]);
                JsonUtil.readJsonAndUpdate((Path)parametersFile, (Object)((Object)params), (ObjectMapper)objectMapper);
            }
            List list = contingencies = line.hasOption(CONTINGENCIES_FILE_OPTION) ? ContingencyList.load((Path)context.getFileSystem().getPath(line.getOptionValue(CONTINGENCIES_FILE_OPTION), new String[0])).getContingencies(network) : Collections.emptyList();
            if (line.hasOption(VARIABLE_SETS_FILE_OPTION)) {
                try (BufferedReader reader = Files.newBufferedReader(context.getFileSystem().getPath(line.getOptionValue(VARIABLE_SETS_FILE_OPTION), new String[0]), StandardCharsets.UTF_8);){
                    variableSets = (List)objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<List<SensitivityVariableSet>>(){});
                }
            } else {
                variableSets = Collections.emptyList();
            }
            SensitivityFactorJsonReader factorsReader = new SensitivityFactorJsonReader(factorsFile);
            context.getOutputStream().println("Running analysis...");
            stopwatch = Stopwatch.createStarted();
            try (ComputationManager computationManager = DefaultComputationManagerConfig.load().createLongTimeExecutionComputationManager();){
                if (line.hasOption(SINGLE_OUTPUT)) {
                    if (csv) {
                        throw new PowsyblException("Unsupported single-output option does not support csv file as argument of output-file. Must be json.");
                    }
                    ArrayList<SensitivityFactor> factors = new ArrayList<SensitivityFactor>();
                    factorsReader.read((functionType, functionId, variableType, variableId, variableSet, contingencyContext) -> factors.add(new SensitivityFactor(functionType, functionId, variableType, variableId, variableSet, contingencyContext)));
                    SensitivityAnalysisResult result = SensitivityAnalysis.run(network, network.getVariantManager().getWorkingVariantId(), factors, contingencies, variableSets, params, computationManager, ReportNode.NO_OP);
                    ObjectMapper sensiObjectMapper = JsonUtil.createObjectMapper().registerModule((Module)new SensitivityJsonModule());
                    JsonUtil.writeJson((Path)outputFile, (Object)result, (ObjectMapper)sensiObjectMapper);
                    break block66;
                }
                if (csv) {
                    try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);
                         BufferedWriter writerStatuses = Files.newBufferedWriter(outputFileStatus, StandardCharsets.UTF_8, new OpenOption[0]);
                         TableFormatter formatter = SensitivityResultCsvWriter.createTableFormatter(writer);
                         TableFormatter formatterStatus = SensitivityResultCsvWriter.createContingencyStatusTableFormatter(writerStatuses);){
                        SensitivityResultCsvWriter valuesWriter = new SensitivityResultCsvWriter(formatter, formatterStatus, contingencies);
                        SensitivityAnalysis.run(network, network.getVariantManager().getWorkingVariantId(), factorsReader, valuesWriter, contingencies, variableSets, params, computationManager, ReportNode.NO_OP);
                        break block66;
                    }
                }
                JsonFactory factory = JsonUtil.createJsonFactory();
                try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);
                     JsonGenerator generator = factory.createGenerator((Writer)writer);
                     SensitivityResultJsonWriter valuesWriter = new SensitivityResultJsonWriter(generator, contingencies);){
                    generator.useDefaultPrettyPrinter();
                    SensitivityAnalysis.run(network, network.getVariantManager().getWorkingVariantId(), factorsReader, valuesWriter, contingencies, variableSets, params, computationManager, ReportNode.NO_OP);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        context.getOutputStream().println("Analysis done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
    }
}

