/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.json.JsonLoadFlowParameters;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.json.JsonSensitivityAnalysisParameters;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SensitivityAnalysisParametersDeserializer
extends StdDeserializer<SensitivityAnalysisParameters> {
    private static final String CONTEXT_NAME = "SensitivityAnalysisParameters";

    SensitivityAnalysisParametersDeserializer() {
        super(SensitivityAnalysisParameters.class);
    }

    public SensitivityAnalysisParameters deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(parser, deserializationContext, new SensitivityAnalysisParameters());
    }

    public SensitivityAnalysisParameters deserialize(JsonParser parser, DeserializationContext deserializationContext, SensitivityAnalysisParameters parameters) throws IOException {
        List extensions = Collections.emptyList();
        String version = null;
        block18: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    continue block18;
                }
                case "load-flow-parameters": {
                    parser.nextToken();
                    JsonLoadFlowParameters.deserialize((JsonParser)parser, (DeserializationContext)deserializationContext, (LoadFlowParameters)parameters.getLoadFlowParameters());
                    continue block18;
                }
                case "flow-flow-sensitivity-value-threshold": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)parser.getCurrentName(), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setFlowFlowSensitivityValueThreshold((Double)parser.readValueAs(Double.class));
                    continue block18;
                }
                case "voltage-voltage-sensitivity-value-threshold": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)parser.getCurrentName(), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setVoltageVoltageSensitivityValueThreshold((Double)parser.readValueAs(Double.class));
                    continue block18;
                }
                case "flow-voltage-sensitivity-value-threshold": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)parser.getCurrentName(), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setFlowVoltageSensitivityValueThreshold((Double)parser.readValueAs(Double.class));
                    continue block18;
                }
                case "angle-flow-sensitivity-value-threshold": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)parser.getCurrentName(), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setAngleFlowSensitivityValueThreshold((Double)parser.readValueAs(Double.class));
                    continue block18;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.updateExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, JsonSensitivityAnalysisParameters.getExtensionSerializers()::get, (Extendable)parameters);
                    continue block18;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        extensions.forEach(extension -> parameters.addExtension(extension.getClass(), (Extension)extension));
        return parameters;
    }
}

