/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.sensitivity.SensitivityAnalysisProvider;
import java.util.Objects;

public class SensitivityAnalysisParameters
extends AbstractExtendable<SensitivityAnalysisParameters> {
    public static final String VERSION = "1.1";
    static final double FLOW_FLOW_SENSITIVITY_VALUE_THRESHOLD_DEFAULT_VALUE = 0.0;
    static final double VOLTAGE_VOLTAGE_SENSITIVITY_VALUE_THRESHOLD_DEFAULT_VALUE = 0.0;
    static final double FLOW_VOLTAGE_SENSITIVITY_VALUE_THRESHOLD_DEFAULT_VALUE = 0.0;
    static final double ANGLE_FLOW_SENSITIVITY_VALUE_THRESHOLD_DEFAULT_VALUE = 0.0;
    private double flowFlowSensitivityValueThreshold = 0.0;
    private double voltageVoltageSensitivityValueThreshold = 0.0;
    private double flowVoltageSensitivityValueThreshold = 0.0;
    private double angleFlowSensitivityValueThreshold = 0.0;
    private LoadFlowParameters loadFlowParameters = new LoadFlowParameters();

    public static SensitivityAnalysisParameters load() {
        return SensitivityAnalysisParameters.load(PlatformConfig.defaultConfig());
    }

    public static SensitivityAnalysisParameters load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        SensitivityAnalysisParameters parameters = new SensitivityAnalysisParameters();
        parameters.readExtensions(platformConfig);
        parameters.setLoadFlowParameters(LoadFlowParameters.load((PlatformConfig)platformConfig));
        return parameters;
    }

    private void readExtensions(PlatformConfig platformConfig) {
        for (SensitivityAnalysisProvider provider : new ServiceLoaderCache(SensitivityAnalysisProvider.class).getServices()) {
            provider.loadSpecificParameters(platformConfig).ifPresent(sensitivityAnalysisParametersExtension -> this.addExtension(sensitivityAnalysisParametersExtension.getClass(), (Extension)sensitivityAnalysisParametersExtension));
        }
    }

    public LoadFlowParameters getLoadFlowParameters() {
        return this.loadFlowParameters;
    }

    public SensitivityAnalysisParameters setLoadFlowParameters(LoadFlowParameters loadFlowParameters) {
        this.loadFlowParameters = Objects.requireNonNull(loadFlowParameters);
        return this;
    }

    public SensitivityAnalysisParameters setFlowFlowSensitivityValueThreshold(double threshold) {
        this.flowFlowSensitivityValueThreshold = threshold;
        return this;
    }

    public double getFlowFlowSensitivityValueThreshold() {
        return this.flowFlowSensitivityValueThreshold;
    }

    public SensitivityAnalysisParameters setVoltageVoltageSensitivityValueThreshold(double threshold) {
        this.voltageVoltageSensitivityValueThreshold = threshold;
        return this;
    }

    public double getVoltageVoltageSensitivityValueThreshold() {
        return this.voltageVoltageSensitivityValueThreshold;
    }

    public SensitivityAnalysisParameters setFlowVoltageSensitivityValueThreshold(double threshold) {
        this.flowVoltageSensitivityValueThreshold = threshold;
        return this;
    }

    public double getFlowVoltageSensitivityValueThreshold() {
        return this.flowVoltageSensitivityValueThreshold;
    }

    public SensitivityAnalysisParameters setAngleFlowSensitivityValueThreshold(double threshold) {
        this.angleFlowSensitivityValueThreshold = threshold;
        return this;
    }

    public double getAngleFlowSensitivityValueThreshold() {
        return this.angleFlowSensitivityValueThreshold;
    }
}

