/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityValue;
import java.io.IOException;
import java.util.List;

public class SensitivityAnalysisResultDeserializer
extends StdDeserializer<SensitivityAnalysisResult> {
    protected SensitivityAnalysisResultDeserializer() {
        super(SensitivityAnalysisResult.class);
    }

    public SensitivityAnalysisResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String version = null;
        List sensitivityValues = null;
        List contingencyStatus = null;
        List factors = null;
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    continue block12;
                }
                case "sensitivityFactors": {
                    parser.nextToken();
                    factors = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, SensitivityFactor.class);
                    continue block12;
                }
                case "sensitivityValues": {
                    parser.nextToken();
                    sensitivityValues = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, SensitivityValue.class);
                    continue block12;
                }
                case "contingencyStatus": {
                    parser.nextToken();
                    contingencyStatus = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, SensitivityAnalysisResult.SensitivityContingencyStatus.class);
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        if (version == null || !version.equals("1.0")) {
            throw new IllegalStateException("Version different than 1.0 not supported.");
        }
        return new SensitivityAnalysisResult(factors, contingencyStatus, sensitivityValues);
    }
}

