/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.sensitivity.SensitivityFunctionType;
import com.powsybl.sensitivity.SensitivityVariableType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SensitivityFactor {
    private final SensitivityFunctionType functionType;
    private final String functionId;
    private final SensitivityVariableType variableType;
    private final String variableId;
    private final boolean variableSet;
    private final ContingencyContext contingencyContext;

    public SensitivityFactor(SensitivityFunctionType functionType, String functionId, SensitivityVariableType variableType, String variableId, boolean variableSet, ContingencyContext contingencyContext) {
        this.functionType = Objects.requireNonNull(functionType);
        this.functionId = Objects.requireNonNull(functionId);
        this.variableType = Objects.requireNonNull(variableType);
        this.variableId = Objects.requireNonNull(variableId);
        this.variableSet = variableSet;
        this.contingencyContext = Objects.requireNonNull(contingencyContext);
    }

    public SensitivityFunctionType getFunctionType() {
        return this.functionType;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public SensitivityVariableType getVariableType() {
        return this.variableType;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public boolean isVariableSet() {
        return this.variableSet;
    }

    public ContingencyContext getContingencyContext() {
        return this.contingencyContext;
    }

    public String toString() {
        return "SensitivityFactor(functionType=" + this.functionType + ", functionId='" + this.functionId + "', variableType=" + this.variableType + ", variableId='" + this.variableId + "', variableSet=" + this.variableSet + ", contingencyContext=" + this.contingencyContext + ")";
    }

    public static void writeJson(JsonGenerator jsonGenerator, SensitivityFactor factor) {
        SensitivityFactor.writeJson(jsonGenerator, factor.getFunctionType(), factor.getFunctionId(), factor.getVariableType(), factor.getVariableId(), factor.isVariableSet(), factor.getContingencyContext());
    }

    public static void writeJson(JsonGenerator jsonGenerator, SensitivityFunctionType functionType, String functionId, SensitivityVariableType variableType, String variableId, boolean variableSet, ContingencyContext contingencyContext) {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("functionType", functionType.name());
            jsonGenerator.writeStringField("functionId", functionId);
            jsonGenerator.writeStringField("variableType", variableType.name());
            jsonGenerator.writeStringField("variableId", variableId);
            jsonGenerator.writeBooleanField("variableSet", variableSet);
            jsonGenerator.writeStringField("contingencyContextType", contingencyContext.getContextType().name());
            if (contingencyContext.getContingencyId() != null) {
                jsonGenerator.writeStringField("contingencyId", contingencyContext.getContingencyId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SensitivityFactor parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        ParsingContext context = new ParsingContext();
        try {
            JsonToken token;
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    SensitivityFactor.parseJson(parser, context);
                    continue;
                }
                if (token != JsonToken.END_OBJECT) continue;
                boolean variableSet = Objects.requireNonNull(context.variableSet, "Parameter variableSet is missing");
                return new SensitivityFactor(context.functionType, context.functionId, context.variableType, context.variableId, variableSet, new ContingencyContext(context.contingencyId, context.contingencyContextType));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new PowsyblException("Parsing error");
    }

    static void parseJson(JsonParser parser, ParsingContext context) throws IOException {
        String fieldName;
        switch (fieldName = parser.currentName()) {
            case "functionType": {
                context.functionType = SensitivityFunctionType.valueOf(parser.nextTextValue());
                break;
            }
            case "functionId": {
                context.functionId = parser.nextTextValue();
                break;
            }
            case "variableType": {
                context.variableType = SensitivityVariableType.valueOf(parser.nextTextValue());
                break;
            }
            case "variableId": {
                context.variableId = parser.nextTextValue();
                break;
            }
            case "variableSet": {
                context.variableSet = parser.nextBooleanValue();
                break;
            }
            case "contingencyContextType": {
                context.contingencyContextType = ContingencyContextType.valueOf((String)parser.nextTextValue());
                break;
            }
            case "contingencyId": {
                context.contingencyId = parser.nextTextValue();
                break;
            }
            default: {
                throw new PowsyblException("Unexpected field: " + fieldName);
            }
        }
    }

    public static List<SensitivityFactor> createMatrix(SensitivityFunctionType functionType, Collection<String> functionIds, SensitivityVariableType variableType, Collection<String> variableIds, boolean variableSet, ContingencyContext contingencyContext) {
        return functionIds.stream().flatMap(functionId -> variableIds.stream().map(variableId -> new SensitivityFactor(functionType, (String)functionId, variableType, (String)variableId, variableSet, contingencyContext))).collect(Collectors.toList());
    }

    static final class ParsingContext {
        SensitivityFunctionType functionType;
        String functionId;
        SensitivityVariableType variableType;
        String variableId;
        Boolean variableSet;
        ContingencyContextType contingencyContextType;
        String contingencyId;

        ParsingContext() {
        }

        void reset() {
            this.functionType = null;
            this.functionId = null;
            this.variableType = null;
            this.variableId = null;
            this.variableSet = null;
            this.contingencyContextType = null;
            this.contingencyId = null;
        }
    }
}

