/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.IdBasedBusRef;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityFunctionType;
import java.util.List;
import java.util.Objects;

public class SensitivityFactorModelReader
implements SensitivityFactorReader {
    private final List<SensitivityFactor> factors;
    private final Network network;

    public SensitivityFactorModelReader(List<SensitivityFactor> factors, Network network) {
        this.factors = Objects.requireNonNull(factors);
        this.network = Objects.requireNonNull(network);
    }

    @Override
    public void read(SensitivityFactorReader.Handler handler) {
        Objects.requireNonNull(handler);
        for (SensitivityFactor factor : this.factors) {
            String functionId = factor.getFunctionId();
            if (factor.getFunctionType() == SensitivityFunctionType.BUS_VOLTAGE) {
                Bus bus = (Bus)new IdBasedBusRef(factor.getFunctionId()).resolve(this.network, TopologyLevel.BUS_BRANCH).orElseThrow(() -> new PowsyblException("The bus ref for '" + factor.getFunctionId() + "' cannot be resolved."));
                functionId = bus.getId();
            }
            handler.onFactor(factor.getFunctionType(), functionId, factor.getVariableType(), factor.getVariableId(), factor.isVariableSet(), factor.getContingencyContext());
        }
    }
}

