/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity;

import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFactorReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;

public class SensitivityFactorJsonReader
implements SensitivityFactorReader {
    private final Path jsonFile;

    public SensitivityFactorJsonReader(Path jsonFile) {
        this.jsonFile = Objects.requireNonNull(jsonFile);
    }

    @Override
    public void read(SensitivityFactorReader.Handler handler) {
        Objects.requireNonNull(handler);
        JsonUtil.parseJson((Path)this.jsonFile, parser -> {
            try {
                JsonToken token;
                SensitivityFactor.ParsingContext context = new SensitivityFactor.ParsingContext();
                while ((token = parser.nextToken()) != null) {
                    if (token == JsonToken.FIELD_NAME) {
                        SensitivityFactor.parseJson(parser, context);
                        continue;
                    }
                    if (token == JsonToken.END_OBJECT) {
                        handler.onFactor(context.functionType, context.functionId, context.variableType, context.variableId, context.variableSet, ContingencyContext.create((String)context.contingencyId, (ContingencyContextType)context.contingencyContextType));
                        context.reset();
                        continue;
                    }
                    if (token != JsonToken.END_ARRAY) continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return null;
        });
    }
}

