/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sensitivity.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisProvider;
import com.powsybl.sensitivity.json.SensitivityJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class JsonSensitivityAnalysisParameters {
    public static Map<String, ExtensionJsonSerializer> getExtensionSerializers() {
        List providers = new ServiceLoaderCache(SensitivityAnalysisProvider.class).getServices();
        return providers.stream().flatMap(securityAnalysisProvider -> securityAnalysisProvider.getSpecificParametersSerializer().stream()).collect(Collectors.toMap(ExtensionProvider::getExtensionName, securityAnalysisProvider -> securityAnalysisProvider));
    }

    private JsonSensitivityAnalysisParameters() {
    }

    public static SensitivityAnalysisParameters read(Path jsonFile) {
        return JsonSensitivityAnalysisParameters.update(new SensitivityAnalysisParameters(), jsonFile);
    }

    public static SensitivityAnalysisParameters read(InputStream jsonStream) {
        return JsonSensitivityAnalysisParameters.update(new SensitivityAnalysisParameters(), jsonStream);
    }

    public static SensitivityAnalysisParameters update(SensitivityAnalysisParameters parameters, Path jsonFile) {
        SensitivityAnalysisParameters sensitivityAnalysisParameters;
        block8: {
            Objects.requireNonNull(jsonFile);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                sensitivityAnalysisParameters = JsonSensitivityAnalysisParameters.update(parameters, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return sensitivityAnalysisParameters;
    }

    public static SensitivityAnalysisParameters update(SensitivityAnalysisParameters parameters, InputStream jsonStream) {
        try {
            ObjectMapper objectMapper = JsonSensitivityAnalysisParameters.createObjectMapper();
            return (SensitivityAnalysisParameters)((Object)objectMapper.readerForUpdating((Object)parameters).readValue(jsonStream));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new SensitivityJsonModule());
    }
}

