/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.security.LimitViolation;
import com.powsybl.shortcircuit.Fault;
import com.powsybl.shortcircuit.FaultResult;
import com.powsybl.shortcircuit.FeederResult;
import com.powsybl.shortcircuit.FortescueFeederResult;
import com.powsybl.shortcircuit.MagnitudeFaultResult;
import com.powsybl.shortcircuit.ShortCircuitBusResults;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class AbstractFaultResult
extends AbstractExtendable<FaultResult>
implements FaultResult {
    private final FaultResult.Status status;
    private final Fault fault;
    private final double shortCircuitPower;
    private final Duration timeConstant;
    private final List<FeederResult> feederResults;
    private final List<LimitViolation> limitViolations;
    private final List<ShortCircuitBusResults> shortCircuitBusResults;

    protected AbstractFaultResult(Fault fault, FaultResult.Status status, double shortCircuitPower, Duration timeConstant, List<FeederResult> feederResults, List<LimitViolation> limitViolations, List<ShortCircuitBusResults> shortCircuitBusResults) {
        this.fault = Objects.requireNonNull(fault);
        this.shortCircuitPower = shortCircuitPower;
        this.limitViolations = new ArrayList<LimitViolation>();
        if (limitViolations != null) {
            this.limitViolations.addAll(limitViolations);
        }
        this.timeConstant = timeConstant;
        this.shortCircuitBusResults = new ArrayList<ShortCircuitBusResults>();
        if (shortCircuitBusResults != null) {
            this.shortCircuitBusResults.addAll(shortCircuitBusResults);
        }
        this.feederResults = new ArrayList<FeederResult>();
        if (feederResults != null) {
            this.feederResults.addAll(feederResults);
        }
        this.status = Objects.requireNonNull(status);
    }

    @Override
    public Fault getFault() {
        return this.fault;
    }

    @Override
    public double getShortCircuitPower() {
        return this.shortCircuitPower;
    }

    @Override
    public List<FeederResult> getFeederResults() {
        return this.feederResults;
    }

    @Override
    public List<LimitViolation> getLimitViolations() {
        return this.limitViolations;
    }

    @Override
    public Duration getTimeConstant() {
        return this.timeConstant;
    }

    @Override
    public List<ShortCircuitBusResults> getShortCircuitBusResults() {
        return this.shortCircuitBusResults;
    }

    @Override
    public FaultResult.Status getStatus() {
        return this.status;
    }

    @Override
    public double getFeederCurrent(String feederId) {
        for (FeederResult feederResult : this.feederResults) {
            if (!feederResult.getConnectableId().equals(feederId)) continue;
            if (feederResult instanceof FortescueFeederResult) {
                FortescueFeederResult fortescueFeederResult = (FortescueFeederResult)feederResult;
                return fortescueFeederResult.getCurrent().getPositiveMagnitude();
            }
            return ((MagnitudeFaultResult)((Object)feederResult)).getCurrent();
        }
        return Double.NaN;
    }
}

