/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.json.ShortCircuitAnalysisJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public interface Fault {
    public String getId();

    public String getElementId();

    public double getRToGround();

    public double getXToGround();

    public Type getType();

    public ConnectionType getConnectionType();

    public FaultType getFaultType();

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new ShortCircuitAnalysisJsonModule());
    }

    public static void write(List<Fault> faults, Path jsonFile) {
        try (OutputStream out = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            Fault.createObjectMapper().writerWithDefaultPrettyPrinter().writeValue(out, faults);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<Fault> read(Path jsonFile) {
        List list;
        block8: {
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                list = (List)Fault.createObjectMapper().readerForListOf(Fault.class).readValue(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return list;
    }

    public static enum FaultType {
        THREE_PHASE,
        SINGLE_PHASE;

    }

    public static enum ConnectionType {
        SERIES,
        PARALLEL;

    }

    public static enum Type {
        BUS,
        BRANCH;

    }
}

